package jp.co.powerbeans.jdbcdebug.sql;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;

import jp.co.powerbeans.jdbcdebug.util.Log;
import jp.co.powerbeans.jdbcdebug.util.Survey;


/**
 * <p>タイトル: PreparedStatement</p>
 * <p>説明: </p>
 * <p>Created on 2003/10/01</p>
 * @author 門田明彦
 * @version $Revision: 1.1 $
 */
public class PreparedStatement implements java.sql.PreparedStatement {

  /** 実 java.sql.PreparedStatement */
	private java.sql.PreparedStatement st;
	
	/** オリジナル SQL */
	private String sql;
  
  /** バッチSQL */
  private ArrayList batchSqlList = new ArrayList();

  /** パラメータマップ 　key:parameterIndex(1.2..), value:object of value */
  private HashMap paramMap = new HashMap();

	
	/**
	 * コンストラクタ
	 * @param statement
	 * @param sql
	 */
	PreparedStatement(java.sql.PreparedStatement statement, String sql) {
		
		st = statement;
		this.sql = sql;
	}

	/**
	 * コンストラクタ
	 */
	private PreparedStatement() {
		super();
	}

	/* (non-Javadoc)
	 * @see java.sql.PreparedStatement#addBatch()
	 */
	public void addBatch() throws SQLException {
		st.addBatch();
    batchSqlList.add(sql);
	}

	/* (non-Javadoc)
	 * @see java.sql.PreparedStatement#clearParameters()
	 */
	public void clearParameters() throws SQLException {
		 st.clearParameters();
	}

	/* (non-Javadoc)
	 * @see java.sql.PreparedStatement#execute()
	 */
	public boolean execute() throws SQLException {

		try {
			Survey s = new Survey();		
			boolean r = st.execute();
			Log.printlnSqlLog("execute " + sql, s.doEnd(), paramMap);
			return r;
		} catch (SQLException e) {
			Log.printlnSqlExceptionLog("execute " + sql, e);
			throw e;
		}

//		long s = System.currentTimeMillis();
//		boolean r = st.execute();
//		Log.println("execute " + sql, s, System.currentTimeMillis());
//		return r;

//		return st.execute();
	}

	/* (non-Javadoc)
	 * @see java.sql.PreparedStatement#executeQuery()
	 */
	public ResultSet executeQuery() throws SQLException {

		try {
			Survey s = new Survey();		
			ResultSet r = st.executeQuery();
			Log.printlnSqlLog("executeQuery " + sql, s.doEnd(), paramMap);
			return r;
		} catch (SQLException e) {
			Log.printlnSqlExceptionLog("executeQuery " + sql, e);
			throw e;
		}

//		Log.println("executeQuery " + sql);
//		return st.executeQuery();
	}

	/* (non-Javadoc)
	 * @see java.sql.PreparedStatement#executeUpdate()
	 */
	public int executeUpdate() throws SQLException {

		try {
			Survey s = new Survey();		
			int r = st.executeUpdate();
			Log.printlnSqlLog("executeUpdate " + sql, s.doEnd(), paramMap);
			return r;
		} catch (SQLException e) {
			Log.printlnSqlExceptionLog("executeUpdate " + sql, e);
			throw e;
		}

//		Log.println("executeUpdate " + sql);
//		return st.executeUpdate();
	}

	/* (non-Javadoc)
	 * @see java.sql.PreparedStatement#getMetaData()
	 */
	public ResultSetMetaData getMetaData() throws SQLException {
		return st.getMetaData();
	}

	/* (non-Javadoc)
	 * @see java.sql.PreparedStatement#getParameterMetaData()
	 */
	public ParameterMetaData getParameterMetaData() throws SQLException {
		return st.getParameterMetaData();
	}

	/* (non-Javadoc)
	 * @see java.sql.PreparedStatement#setArray(int, java.sql.Array)
	 */
	public void setArray(int i, Array x) throws SQLException {
		st.setArray(i, x);
    // AMS paramPut
	}

	/* (non-Javadoc)
	 * @see java.sql.PreparedStatement#setAsciiStream(int, java.io.InputStream, int)
	 */
	public void setAsciiStream(int parameterIndex, InputStream x, int length)
		throws SQLException {
		st.setAsciiStream(parameterIndex, x, length);
    // AMS paramPut
	}

	/* (non-Javadoc)
	 * @see java.sql.PreparedStatement#setBigDecimal(int, java.math.BigDecimal)
	 */
	public void setBigDecimal(int parameterIndex, BigDecimal x)
		throws SQLException {
		st.setBigDecimal(parameterIndex, x);
    putParam(parameterIndex, (Object)x);
	}

  /* (non-Javadoc)
	 * @see java.sql.PreparedStatement#setBinaryStream(int, java.io.InputStream, int)
	 */
	public void setBinaryStream(int parameterIndex, InputStream x, int length)
		throws SQLException {
		st.setBinaryStream(parameterIndex, x, length);
    // AMS paramPut
	}

	/* (non-Javadoc)
	 * @see java.sql.PreparedStatement#setBlob(int, java.sql.Blob)
	 */
	public void setBlob(int i, Blob x) throws SQLException {
		st.setBlob(i, x);
    putParam(i, x);
	}

	/* (non-Javadoc)
	 * @see java.sql.PreparedStatement#setBoolean(int, boolean)
	 */
	public void setBoolean(int parameterIndex, boolean x) throws SQLException {
		st.setBoolean(parameterIndex, x);
    putParam(parameterIndex, x ? Boolean.TRUE : Boolean.FALSE);
	}

	/* (non-Javadoc)
	 * @see java.sql.PreparedStatement#setByte(int, byte)
	 */
	public void setByte(int parameterIndex, byte x) throws SQLException {
		st.setByte(parameterIndex, x);
    putParam(parameterIndex, new Byte(x));
	}

	/* (non-Javadoc)
	 * @see java.sql.PreparedStatement#setBytes(int, byte[])
	 */
	public void setBytes(int parameterIndex, byte[] x) throws SQLException {
		st.setBytes(parameterIndex, x);
    putParam(parameterIndex, x);
	}

	/* (non-Javadoc)
	 * @see java.sql.PreparedStatement#setCharacterStream(int, java.io.Reader, int)
	 */
	public void setCharacterStream(
		int parameterIndex,
		Reader reader,
		int length)
		throws SQLException {
		st.setCharacterStream(parameterIndex, reader, length);
    // AMS paramPut
	}

	/* (non-Javadoc)
	 * @see java.sql.PreparedStatement#setClob(int, java.sql.Clob)
	 */
	public void setClob(int i, Clob x) throws SQLException {
		st.setClob(i, x);
    putParam(i, x);
	}

	/* (non-Javadoc)
	 * @see java.sql.PreparedStatement#setDate(int, java.sql.Date, java.util.Calendar)
	 */
	public void setDate(int parameterIndex, Date x, Calendar cal)
		throws SQLException {
		st.setDate(parameterIndex, x, cal);
    putParam(parameterIndex, x);
	}

	/* (non-Javadoc)
	 * @see java.sql.PreparedStatement#setDate(int, java.sql.Date)
	 */
	public void setDate(int parameterIndex, Date x) throws SQLException {
		st.setDate(parameterIndex, x);
    putParam(parameterIndex, x);
	}

	/* (non-Javadoc)
	 * @see java.sql.PreparedStatement#setDouble(int, double)
	 */
	public void setDouble(int parameterIndex, double x) throws SQLException {
		st.setDouble(parameterIndex, x);
    putParam(parameterIndex, new Double(x));
	}

	/* (non-Javadoc)
	 * @see java.sql.PreparedStatement#setFloat(int, float)
	 */
	public void setFloat(int parameterIndex, float x) throws SQLException {
		st.setFloat(parameterIndex, x);
    putParam(parameterIndex, new Float(x));
	}

	/* (non-Javadoc)
	 * @see java.sql.PreparedStatement#setInt(int, int)
	 */
	public void setInt(int parameterIndex, int x) throws SQLException {
		st.setInt(parameterIndex, x);
    putParam(parameterIndex, new Integer(x));
	}

	/* (non-Javadoc)
	 * @see java.sql.PreparedStatement#setLong(int, long)
	 */
	public void setLong(int parameterIndex, long x) throws SQLException {
		st.setLong(parameterIndex, x);
    putParam(parameterIndex, new Long(x));
	}

	/* (non-Javadoc)
	 * @see java.sql.PreparedStatement#setNull(int, int, java.lang.String)
	 */
	public void setNull(int paramIndex, int sqlType, String typeName)
		throws SQLException {
		st.setNull(paramIndex, sqlType, typeName);
    putParam(paramIndex, "null(" + sqlType + ")");
	}

	/* (non-Javadoc)
	 * @see java.sql.PreparedStatement#setNull(int, int)
	 */
	public void setNull(int parameterIndex, int sqlType) throws SQLException {
		st.setNull(parameterIndex, sqlType);
    putParam(parameterIndex, "null(" + sqlType + ")");
	}

	/* (non-Javadoc)
	 * @see java.sql.PreparedStatement#setObject(int, java.lang.Object, int, int)
	 */
	public void setObject(
		int parameterIndex,
		Object x,
		int targetSqlType,
		int scale)
		throws SQLException {
		st.setObject(parameterIndex,x,targetSqlType,scale);
    putParam(parameterIndex,x);
	}

	/* (non-Javadoc)
	 * @see java.sql.PreparedStatement#setObject(int, java.lang.Object, int)
	 */
	public void setObject(int parameterIndex, Object x, int targetSqlType)
		throws SQLException {
		st.setObject(parameterIndex, x, targetSqlType);
    putParam(parameterIndex, x);
	}

	/* (non-Javadoc)
	 * @see java.sql.PreparedStatement#setObject(int, java.lang.Object)
	 */
	public void setObject(int parameterIndex, Object x) throws SQLException {
		st.setObject(parameterIndex, x);
    putParam(parameterIndex, x);
	}

	/* (non-Javadoc)
	 * @see java.sql.PreparedStatement#setRef(int, java.sql.Ref)
	 */
	public void setRef(int i, Ref x) throws SQLException {
		st.setRef(i, x);
    putParam(i, x);
	}

	/* (non-Javadoc)
	 * @see java.sql.PreparedStatement#setShort(int, short)
	 */
	public void setShort(int parameterIndex, short x) throws SQLException {
		 st.setShort(parameterIndex, x);
    putParam(parameterIndex, new Short(x));
	}

	/* (non-Javadoc)
	 * @see java.sql.PreparedStatement#setString(int, java.lang.String)
	 */
	public void setString(int parameterIndex, String x) throws SQLException {
		st.setString(parameterIndex, x);
    putParam(parameterIndex, x);
	}

	/* (non-Javadoc)
	 * @see java.sql.PreparedStatement#setTime(int, java.sql.Time, java.util.Calendar)
	 */
	public void setTime(int parameterIndex, Time x, Calendar cal)
		throws SQLException {
		st.setTime(parameterIndex, x, cal);
    putParam(parameterIndex, x);
	}

	/* (non-Javadoc)
	 * @see java.sql.PreparedStatement#setTime(int, java.sql.Time)
	 */
	public void setTime(int parameterIndex, Time x) throws SQLException {
		st.setTime(parameterIndex, x);
    putParam(parameterIndex, x);
	}

	/* (non-Javadoc)
	 * @see java.sql.PreparedStatement#setTimestamp(int, java.sql.Timestamp, java.util.Calendar)
	 */
	public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal)
		throws SQLException {
		st.setTimestamp(parameterIndex, x, cal);
    putParam(parameterIndex, x);
	}

	/* (non-Javadoc)
	 * @see java.sql.PreparedStatement#setTimestamp(int, java.sql.Timestamp)
	 */
	public void setTimestamp(int parameterIndex, Timestamp x)
		throws SQLException {
		st.setTimestamp(parameterIndex, x);
    putParam(parameterIndex, x);
	}

	/**
	 * @see java.sql.PreparedStatement#setUnicodeStream(int, java.io.InputStream, int)
	 * @deprecated
	 */
	public void setUnicodeStream(int parameterIndex, InputStream x, int length)
		throws SQLException {
		st.setUnicodeStream(parameterIndex, x, length);
    // AMS putParam(parameterIndex, x);
	}

	/* (non-Javadoc)
	 * @see java.sql.PreparedStatement#setURL(int, java.net.URL)
	 */
	public void setURL(int parameterIndex, URL x) throws SQLException {
		st.setURL(parameterIndex, x);
    putParam(parameterIndex, x);
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#addBatch(java.lang.String)
	 */
	public void addBatch(String sql) throws SQLException {
		st.addBatch(sql);
    batchSqlList.add(sql);
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#cancel()
	 */
	public void cancel() throws SQLException {
		st.cancel();
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#clearBatch()
	 */
	public void clearBatch() throws SQLException {
		st.clearBatch();
    batchSqlList.clear();
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#clearWarnings()
	 */
	public void clearWarnings() throws SQLException {
		st.clearWarnings();
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#close()
	 */
	public void close() throws SQLException {
		st.close();
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#execute(java.lang.String, int)
	 */
	public boolean execute(String sql, int autoGeneratedKeys)
		throws SQLException {

		try {
			Survey s = new Survey();		
			boolean r = st.execute(sql, autoGeneratedKeys);
			Log.printlnSqlLog("executeQuery " + sql, s.doEnd(), paramMap);
			return r;
		} catch (SQLException e) {
			Log.printlnSqlExceptionLog("executeQuery " + sql, e);
			throw e;
		}

//			long s = System.currentTimeMillis();
//			boolean r = st.execute(sql, autoGeneratedKeys);
//			Log.println("executeQuery " + sql, s, System.currentTimeMillis());
//			return r;
			
//		Log.println("execute " + sql);
//		return st.execute(sql, autoGeneratedKeys);
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#execute(java.lang.String, int[])
	 */
	public boolean execute(String sql, int[] columnIndexes)
		throws SQLException {

			try {
				Survey s = new Survey();		
				boolean r = st.execute(sql, columnIndexes);
				Log.printlnSqlLog("execute " + sql, s.doEnd(), paramMap);
				return r;
			} catch (SQLException e) {
				Log.printlnSqlExceptionLog("execute " + sql, e);
				throw e;
			}

//		Log.println("execute " + sql);
//		return st.execute(sql, columnIndexes);
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#execute(java.lang.String, java.lang.String[])
	 */
	public boolean execute(String sql, String[] columnNames)
		throws SQLException {

			try {
				Survey s = new Survey();		
				boolean r = st.execute(sql, columnNames);
				Log.printlnSqlLog("execute " + sql, s.doEnd(), paramMap);
				return r;
			} catch (SQLException e) {
				Log.printlnSqlExceptionLog("execute " + sql, e);
				throw e;
			}

//			Log.println("execute " + sql);
//		return st.execute(sql, columnNames);
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#execute(java.lang.String)
	 */
	public boolean execute(String sql) throws SQLException {

		try {
			Survey s = new Survey();		
			boolean r = st.execute(sql);
			Log.printlnSqlLog("execute " + sql, s.doEnd(), paramMap);
			return r;
		} catch (SQLException e) {
			Log.printlnSqlExceptionLog("execute " + sql, e);
			throw e;
		}

//		Log.println("execute " + sql);
//		return st.execute(sql);
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#executeBatch()
	 */
	public int[] executeBatch() throws SQLException {

    try {
      Survey s = new Survey();
      int[] c = st.executeBatch();

      // 実行したSQLを全て出力
      int i = 0;
      for(Iterator it = batchSqlList.iterator(); it.hasNext();i++) {
        Log.printlnSqlLog("executeBatch " + it.next() + ", result " + c[i], s.doEnd(), paramMap);
      }
      return c;
    
    } catch (SQLException e) {
      Log.printlnSqlExceptionLog("executeBatch ", e);
      throw e;
    } finally {
      batchSqlList.clear();
    }
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#executeQuery(java.lang.String)
	 */
	public ResultSet executeQuery(String sql) throws SQLException {

		try {
			Survey s = new Survey();		
			ResultSet r = st.executeQuery(sql);
			Log.printlnSqlLog("executeQuery " + sql, s.doEnd(), paramMap);
			return r;
		} catch (SQLException e) {
			Log.printlnSqlExceptionLog("executeQuery " + sql, e);
			throw e;
		}

//		Log.println("executeQuery " + sql);
//		return st.executeQuery(sql);
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#executeUpdate(java.lang.String, int)
	 */
	public int executeUpdate(String sql, int autoGeneratedKeys)
		throws SQLException {

			try {
				Survey s = new Survey();		
				int r = st.executeUpdate(sql, autoGeneratedKeys);
				Log.printlnSqlLog("executeUpdate " + sql, s.doEnd(), paramMap);
				return r;
			} catch (SQLException e) {
				Log.printlnSqlExceptionLog("executeUpdate " + sql, e);
				throw e;
			}
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#executeUpdate(java.lang.String, int[])
	 */
	public int executeUpdate(String sql, int[] columnIndexes)
		throws SQLException {

			try {
				Survey s = new Survey();		
				int r = st.executeUpdate(sql, columnIndexes);
				Log.printlnSqlLog("executeUpdate " + sql, s.doEnd(), paramMap);
				return r;
			} catch (SQLException e) {
				Log.printlnSqlExceptionLog("executeUpdate " + sql, e);
				throw e;
			}
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#executeUpdate(java.lang.String, java.lang.String[])
	 */
	public int executeUpdate(String sql, String[] columnNames)
		throws SQLException {

			try {
				Survey s = new Survey();		
				int r = st.executeUpdate(sql, columnNames);
				Log.printlnSqlLog("executeUpdate " + sql, s.doEnd(), paramMap);
				return r;
			} catch (SQLException e) {
				Log.printlnSqlExceptionLog("executeUpdate " + sql, e);
				throw e;
			}
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#executeUpdate(java.lang.String)
	 */
	public int executeUpdate(String sql) throws SQLException {

		try {
			Survey s = new Survey();		
			int r = st.executeUpdate(sql);
			Log.printlnSqlLog("executeUpdate " + sql, s.doEnd(), paramMap);
			return r;
		} catch (SQLException e) {
			Log.printlnSqlExceptionLog("executeUpdate " + sql, e);
			throw e;
		}

//		Log.println("executeUpdate " + sql);
//		return st.executeUpdate(sql);
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#getConnection()
	 */
	public Connection getConnection() throws SQLException {
		return st.getConnection();
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#getFetchDirection()
	 */
	public int getFetchDirection() throws SQLException {
		return st.getFetchDirection();
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#getFetchSize()
	 */
	public int getFetchSize() throws SQLException {
		return st.getFetchSize();
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#getGeneratedKeys()
	 */
	public ResultSet getGeneratedKeys() throws SQLException {
		return st.getGeneratedKeys();
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#getMaxFieldSize()
	 */
	public int getMaxFieldSize() throws SQLException {
		return st.getMaxFieldSize();
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#getMaxRows()
	 */
	public int getMaxRows() throws SQLException {
		return st.getMaxRows();
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#getMoreResults()
	 */
	public boolean getMoreResults() throws SQLException {
		return st.getMoreResults();
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#getMoreResults(int)
	 */
	public boolean getMoreResults(int current) throws SQLException {
		return st.getMoreResults(current);
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#getQueryTimeout()
	 */
	public int getQueryTimeout() throws SQLException {
		return st.getQueryTimeout();
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#getResultSet()
	 */
	public ResultSet getResultSet() throws SQLException {
		return st.getResultSet();
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#getResultSetConcurrency()
	 */
	public int getResultSetConcurrency() throws SQLException {
		return st.getResultSetConcurrency();
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#getResultSetHoldability()
	 */
	public int getResultSetHoldability() throws SQLException {
		return st.getResultSetHoldability();
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#getResultSetType()
	 */
	public int getResultSetType() throws SQLException {
		return st.getResultSetType();
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#getUpdateCount()
	 */
	public int getUpdateCount() throws SQLException {
		return st.getUpdateCount();
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#getWarnings()
	 */
	public SQLWarning getWarnings() throws SQLException {
		return st.getWarnings();
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#setCursorName(java.lang.String)
	 */
	public void setCursorName(String name) throws SQLException {
		st.setCursorName(name);
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#setEscapeProcessing(boolean)
	 */
	public void setEscapeProcessing(boolean enable) throws SQLException {
		 st.setEscapeProcessing(enable);
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#setFetchDirection(int)
	 */
	public void setFetchDirection(int direction) throws SQLException {
		 st.setFetchDirection(direction);
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#setFetchSize(int)
	 */
	public void setFetchSize(int rows) throws SQLException {
		st.setFetchSize(rows);
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#setMaxFieldSize(int)
	 */
	public void setMaxFieldSize(int max) throws SQLException {
		st.setMaxFieldSize(max);
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#setMaxRows(int)
	 */
	public void setMaxRows(int max) throws SQLException {
		st.setMaxRows(max);
	}

	/* (non-Javadoc)
	 * @see java.sql.Statement#setQueryTimeout(int)
	 */
	public void setQueryTimeout(int seconds) throws SQLException {
		st.setQueryTimeout(seconds);
	}

  /**
   * paramPut<BR>
   * パラメーターマップに値を格納
   * @param parameterIndex パラメータインデックス(1.2..)
   * @param object 値
   */
  private void putParam(int parameterIndex, Object object) {
    
    paramPut(Integer.toString(parameterIndex), object);

  }

  /**
   * paramPut<BR>
   * パラメーターマップに値を格納
   * @param parameterIndex パラメータインデックス("1"."2"..)
   * @param object 値
   */
  private void paramPut(String parameterIndex, Object object) {

    paramMap.put(parameterIndex, object);
    
  }

}
