package jp.co.powerbeans.jdbcdebug.util;

import java.sql.Connection;
import java.util.HashMap;
import java.util.Timer;

import jp.co.powerbeans.jdbcdebug.sql.Driver;

/**
 * <p>プロジェクト名: JDBCDebug</p>
 * <p>タイトル: ConCheckMgr</p>
 * <p>説明: ConCheckThread, Group を管理するクラス</p>
 * <p>Created on 2003/11/11</p>
 * @author 門田明彦
 * @version $Revision: 1.1 $
 */
public final class ConCheckMgr {

	/** コネクション管理Map */
	private static HashMap conMap = new HashMap();
    
  /** コネクションチェックタイマー */
  private static Timer checkTimer;
  
  /**
   * タイマー初期化
   */
	public static void initTimer() {

		if (checkTimer != null) {
      // 既に作成済みの場合は終了
      return;
//			checkTimer.cancel();
    }

		if (ConCheckTask.INTERVAL_TIME > 0 && ConCheckTask.OUTPUT_OVER_TIME > 0) {
			// 1 以上の場合だけタイマー設定
      checkTimer = new Timer();
			checkTimer.schedule(new ConCheckTask(), 1000,
					ConCheckTask.INTERVAL_TIME);
      Log.println("start connection check timer. over=" + ConCheckTask.OUTPUT_OVER_TIME + 
            " interval=" + ConCheckTask.INTERVAL_TIME + " " + Driver.getDriverInstance());
		}
	}

	/**
	 * addChecker <BR>
	 * 新規コネクションが渡されたのでコネクション監視開始
	 * 
	 * @param con
	 *            新規コネクション
	 */
	public static void addChecker(Connection con) {

		// コネクション追加
    if (con != null) {
        Log.println("addChecker " + con);
    		conMap.put(con.toString(), new ConnectionDtl(con));
    }
	}

	/**
	 * removeChecker<BR>
	 * コネクションチェックリストから解除
	 * @param con 新規コネクション
	 */
	public static void removeChecker(Connection con) {

		// コネクション追加
    Log.println("removeChecker " + con);
		conMap.remove(con.toString());
	}
	/**
	 * closed<BR>
	 * コネクションが閉じられたので監視を終了
	 * @param rcon 既にcloseされたコネクション
	 */
	public static void closed(Connection rcon) {
    Log.println("closed " + rcon);
		if (conMap.containsKey(rcon.toString())) {
			// 管理Mapから削除
			// 特にログには出力しない
			
			ConnectionDtl dtl = (ConnectionDtl)conMap.get(rcon.toString());
			conMap.remove(rcon.toString());
			dtl.setCon(null); // 一応クリア
      Log.println("closed ok " + rcon);

		} else {
			// 管理Map に無いConnectionが渡された?
			Log.println("[ConCheck] closed connection which jdbc debugger not checked.");
		}
	}

	/**
	 * getConMap<BR>
	 * @return
	 */
	public static HashMap getConMap() {
		return conMap;
	}

}
