package jp.co.powerbeans.jdbcdebug.util;

import java.util.Properties;
import java.util.TimerTask;

import jp.co.powerbeans.jdbcdebug.sql.Driver;

/**
 * <p>プロジェクト名: JDBCDebug</p>
 * <p>タイトル: ConCheckTask</p>
 * <p>説明: コネクションチェックタイマータスク</p>
 * <p>Created on 2003/11/11</p>
 * @author 門田明彦
 * @version $Revision: 1.1 $
 */
public class ConCheckTask extends TimerTask {

	/** これ以上接続しているとログに出力するコネクション時間 */
	public static long OUTPUT_OVER_TIME = 0;
	
	/** チェック間隔 ms */
	public static long INTERVAL_TIME = 0;
	
	/**
	 * 
	 */
	public ConCheckTask() {
		super();
	}

	/* (non-Javadoc)
	 * @see java.lang.Runnable#run()
	 */
	public void run() {
		
		// タスク実行
		// 有効なコネクション一覧から数秒経過しているものを一覧表示
		
		String[] keys = (String[])ConCheckMgr.getConMap().keySet().toArray(new String[0]);
		long now = System.currentTimeMillis();
		Log.println("[ConCheck] connection check start. connection num " + keys.length); 

		for(int i = 0; i < keys.length; i++) {
			ConnectionDtl dtl = (ConnectionDtl)ConCheckMgr.getConMap().get(keys[i]);
			if (dtl != null) {
				
				// 経過時間を取得
				long delta =  now - dtl.getConStartTime();
				
				if (delta >= OUTPUT_OVER_TIME) {
					Log.println("[ConCheck] ### forgot to close connection? " + (delta / 60000) + ":" + ((delta / 1000) % 60) + "sec   expired.\n" + 
						dtl.getTrace());
				}
				
			}
		}
		
	}

	/**
	 * URLのパラメータを反映
	 * @param prop
	 */
	public static void applyProperties(Properties prop) {

		// output_over_time を超えて接続しているとログに出力する間隔
		String output_over_time = prop.getProperty(Driver.KEY_OUTPUT_OVER_TIME);
		if (output_over_time != null) {
			try {
				OUTPUT_OVER_TIME = Long.parseLong(output_over_time);
			} catch (NumberFormatException e) {
        System.err.print("invalid param " + Driver.KEY_OUTPUT_OVER_TIME
                + "=" + output_over_time);
			}
		}

		// ConCheckTaskを起動する間隔
		String con_check_task = prop.getProperty(Driver.KEY_INTERVAL_TIME);
		if (con_check_task != null) {
			try {
				INTERVAL_TIME = Long.parseLong(con_check_task);
			} catch (NumberFormatException e) {
				System.err.print("invalid param " + Driver.KEY_INTERVAL_TIME
						+ "=" + con_check_task);
			}

		}
	}

}
