package jp.co.powerbeans.jdbcdebug.util;

import java.sql.Connection;

/**
 * <p>プロジェクト名: JDBCDebug</p>
 * <p>タイトル: ConnectionDtl</p>
 * <p>説明: </p>
 * <p>Created on 2003/11/11</p>
 * @author 門田明彦
 * @version $Revision: 1.1 $
 */
/**
 * ConnectionDtl
 * コネクション詳細情報
 */
public class ConnectionDtl {
	
	// connection time ms
	private long conStartTime;
	
	// Connection
	private Connection con;
	
	// Trace (呼び出し元コードを表示するため)
	private String trace = "";

	/**
	 * @param con
	 */
	public ConnectionDtl(Connection con) {

		this.con = con;
		conStartTime = System.currentTimeMillis();
		
		// Trace 取得
		StackTraceElement[] el = new Exception().getStackTrace();
		trace = formatStackTrace(el);
	}

	/**
     * @param el
     * @author  amonden
     */
    public static String formatStackTrace(StackTraceElement[] el) {
        StringBuffer buf = new StringBuffer();
			
		for(int i = 0; i < el.length; i++) {
    buf.append("    " + el[i].toString() + "\n");
//        buf.append("    " + el[i].getClassName() + "." + el[i].getMethodName() + "() Line:" + el[i].getLineNumber() + "\n");
		}
		return buf.toString();
    }

    /**
	 * getConStartTime<BR>
	 * @return
	 */
	public long getConStartTime() {
		return conStartTime;
	}

	/**
	 * getCon<BR>
	 * @return
	 */
	public Connection getCon() {
		return con;
	}

	/**
	 * setCon<BR>
	 * @param connection
	 */
	public void setCon(Connection connection) {
		con = connection;
	}

	/**
	 * getTrace<BR>
	 * @return
	 */
	public String getTrace() {
		return trace;
	}

}