/*
 * Decompiled with CFR 0.152.
 */
package ams.com.ams.jdbcdebug.sql;

import ams.com.ams.jdbcdebug.sql.Connection;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import java.util.ResourceBundle;

public class Driver
implements java.sql.Driver {
    private java.sql.Driver rdb_driver;
    public static final String JDBC_DEBUG_PROPERTY = "jdbcdebug";
    static final String KEY_DRIVER = "Driver";
    public static final String KEY_OUTPUT_TYPE = "OutputType";
    public static String KEY_OUTPUT_PREFIX = "OutputPrefix";

    public Driver() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        ResourceBundle bundle = ResourceBundle.getBundle(JDBC_DEBUG_PROPERTY);
        String driver_name = bundle.getString(KEY_DRIVER);
        if (driver_name == null || driver_name.length() == 0) {
            throw new RuntimeException("jdbcdebug driver_name = \"" + driver_name + "\"");
        }
        try {
            this.rdb_driver = (java.sql.Driver)Class.forName(driver_name).newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new ClassNotFoundException("Not found JDBC driver (Oracle, MySQL..)", e);
        }
    }

    public java.sql.Connection connect(String url, Properties info) throws SQLException {
        return new Connection(this.rdb_driver.connect(url, info));
    }

    public boolean acceptsURL(String url) throws SQLException {
        return this.rdb_driver.acceptsURL(url);
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return this.rdb_driver.getPropertyInfo(url, info);
    }

    public int getMajorVersion() {
        return this.rdb_driver.getMajorVersion();
    }

    public int getMinorVersion() {
        return this.rdb_driver.getMinorVersion();
    }

    public boolean jdbcCompliant() {
        return this.rdb_driver.jdbcCompliant();
    }
}

