/* ****************************************************************************
 * Copyright (c) 2002 Java Eclipse Extension Project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 * ============================================================================
 * $Header: /cvsroot/jeextension/jp.sourceforge.jeextension.jspc/src/jp/sourceforge/jeextension/jspc/EclipseJspCPlugin.java,v 1.3 2004/05/08 08:25:26 kohnosuke Exp $
 * $Revision: 1.3 $
 * $Date: 2004/05/08 08:25:26 $
 * ============================================================================
 * ***************************************************************************/

package jp.sourceforge.jeextension.jspc;

import org.eclipse.ui.plugin.*;
import org.eclipse.core.runtime.*;
import org.eclipse.core.resources.*;
import org.eclipse.jface.preference.IPreferenceStore;

import java.util.*;

import jp.sourceforge.jeextension.jspc.preferences.JspCPreferencePage;

/**
 * The main plugin class to be used in the desktop.
 */
public class EclipseJspCPlugin extends AbstractUIPlugin {
	
    //The shared instance.
	private static EclipseJspCPlugin plugin;
	
    //Resource bundle.
	private ResourceBundle resourceBundle;
	
	/**
	 * The constructor.
	 */
	public EclipseJspCPlugin(IPluginDescriptor descriptor) {
		super(descriptor);
		plugin = this;
		try {
			resourceBundle= ResourceBundle.getBundle("resources");
		} catch (MissingResourceException x) {
			resourceBundle = null;
		}
	}

	/**
	 * Returns the shared instance.
	 */
	public static EclipseJspCPlugin getDefault() {
		return plugin;
	}

	/**
	 * Returns the workspace instance.
	 */
	public static IWorkspace getWorkspace() {
		return ResourcesPlugin.getWorkspace();
	}

	/**
	 * Returns the string from the plugin's resource bundle,
	 * or 'key' if not found.
	 */
	public static String getResourceString(String key) {
		ResourceBundle bundle= EclipseJspCPlugin.getDefault().getResourceBundle();
		try {
			return bundle.getString(key);
		} catch (MissingResourceException e) {
			return key;
		}
	}

	/**
	 * Returns the plugin's resource bundle,
	 */
	public ResourceBundle getResourceBundle() {
		return resourceBundle;
	}
    
    /**
     * Returns the Shift_JIS using code-page.
     * @return
     */
    public static String getShiftJISCodePage() {
        IPreferenceStore store = getDefault().getPreferenceStore();
        String p = store.getString(JspCPreferencePage.P_SHIFTJIS);
        if (p.equals("")) {
            return JspCPreferencePage.DEFAULT_SHIFTJIS;
        } else {
            return p;
        }
    }
    
    /**
     * Returns setted Jsp's package name.
     * @return
     */
    public static String getJspPackage() {
        IPreferenceStore store = getDefault().getPreferenceStore();
        String p = store.getString(JspCPreferencePage.P_PACKAGE);
        if (p.equals("")) {
            return JspCPreferencePage.DEFAULT_PACKAGE;
        } else {
            return p;
        }
    }
    
    /**
     * Returns the output dir.
     * @return
     */
    public static String getOutputDir() {
        IPreferenceStore store = getDefault().getPreferenceStore();
        String p = store.getString(JspCPreferencePage.P_OUTPUT_DIR);
        if (p.equals("")) {
            return JspCPreferencePage.DEFAULT_OUTPUT_DIR;
        } else {
            return p;
        }
    }
}
