/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jeextension.common.xml;

import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jp.sourceforge.jeextension.common.xml.XMLException;
import jp.sourceforge.jeextension.common.xml.XMLNode;
import jp.sourceforge.jeextension.common.xml.XMLNodeList;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public final class XMLDocumentBuilder {
    private Document document;
    private XMLNode sourceXMLNode;

    XMLDocumentBuilder(XMLNode xMLNode) {
        this.sourceXMLNode = xMLNode;
    }

    public Document build() throws XMLException {
        Element element = this.createDocumentElement();
        if (this.sourceXMLNode.hasChildNodes()) {
            this.buildDocument(element, this.sourceXMLNode);
        } else {
            String string = this.sourceXMLNode.getNodeValue();
            Text text = this.document.createTextNode(string);
            if (this.sourceXMLNode.hasAttributes()) {
                this.copyAttrs(element, this.sourceXMLNode);
            }
            element.appendChild(text);
        }
        this.document.appendChild(element);
        return this.document;
    }

    private void buildDocument(Node node, XMLNode xMLNode) {
        XMLNodeList xMLNodeList = xMLNode.getChildNodes();
        int n = 0;
        while (n < xMLNodeList.size()) {
            XMLNode xMLNode2 = (XMLNode)xMLNodeList.get(n);
            Element element = this.toElement(xMLNode2);
            if (xMLNode2.hasChildNodes()) {
                this.buildDocument(element, xMLNode2);
            }
            node.appendChild(element);
            ++n;
        }
    }

    private void copyAttrs(Node node, XMLNode xMLNode) {
        Map map = xMLNode.getAttributes();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)map.get(string);
            Attr attr = this.document.createAttribute(string);
            attr.setValue(string2);
            NamedNodeMap namedNodeMap = node.getAttributes();
            namedNodeMap.setNamedItem(attr);
        }
    }

    private Element createDocumentElement() throws XMLException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            this.document = documentBuilder.newDocument();
            Element element = this.document.createElement(this.sourceXMLNode.getNodeName());
            if (this.sourceXMLNode.hasAttributes()) {
                this.copyAttrs(element, this.sourceXMLNode);
            }
            return element;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new XMLException(parserConfigurationException);
        }
    }

    private Element toElement(XMLNode xMLNode) {
        String string = xMLNode.getNodeName();
        String string2 = xMLNode.getNodeValue();
        Element element = this.document.createElement(string);
        if (!string2.equals("")) {
            Text text = this.document.createTextNode(string2);
            element.appendChild(text);
        }
        if (xMLNode.hasAttributes()) {
            this.copyAttrs(element, xMLNode);
        }
        return element;
    }
}

