/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jeextension.common.xml;

import java.util.Map;
import jp.sourceforge.jeextension.common.xml.XMLException;
import jp.sourceforge.jeextension.common.xml.XMLNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class XMLNodeBuilder {
    private Document sourceDocument;

    XMLNodeBuilder(Document document) {
        this.sourceDocument = document;
    }

    public XMLNode build() throws XMLException {
        XMLNode xMLNode = this.createXMLNode();
        Element element = this.sourceDocument.getDocumentElement();
        this.buildXMLNode(element.getFirstChild(), xMLNode);
        return xMLNode;
    }

    private XMLNode createXMLNode() {
        Element element = this.sourceDocument.getDocumentElement();
        XMLNode xMLNode = new XMLNode(element.getNodeName());
        if (element.hasAttributes()) {
            this.buildAttrs(element, xMLNode);
        }
        return xMLNode;
    }

    private void buildXMLNode(Node node, XMLNode xMLNode) throws XMLException {
        while (node != null) {
            if (node.getNodeType() == 1) {
                XMLNode xMLNode2 = new XMLNode(node.getNodeName());
                if (node.hasAttributes()) {
                    this.buildAttrs(node, xMLNode2);
                }
                this.buildNodeValue(node.getFirstChild(), xMLNode2);
                xMLNode.addChild(xMLNode2);
                this.buildXMLNode(node.getFirstChild(), xMLNode2);
            }
            node = node.getNextSibling();
        }
    }

    private void buildAttrs(Node node, XMLNode xMLNode) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        Map map = xMLNode.getAttributes();
        int n = 0;
        while (n < namedNodeMap.getLength()) {
            Attr attr = (Attr)namedNodeMap.item(n);
            String string = attr.getName();
            String string2 = attr.getValue();
            map.put(string, string2);
            ++n;
        }
    }

    private void buildNodeValue(Node node, XMLNode xMLNode) {
        block2: {
            if (node == null) break block2;
            StringBuffer stringBuffer = new StringBuffer();
            while (node != null) {
                stringBuffer.append(node.getNodeValue());
                node = node.getNextSibling();
            }
            String string = stringBuffer.toString();
            if (!string.startsWith("\n")) {
                xMLNode.setNodeValue(string);
            }
        }
    }
}

