/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jeextension.common.xml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import jp.sourceforge.jeextension.common.xml.XMLDocumentBuilder;
import jp.sourceforge.jeextension.common.xml.XMLException;
import jp.sourceforge.jeextension.common.xml.XMLNode;
import org.apache.xml.serializer.SerializerBase;
import org.apache.xml.serializer.ToXMLStream;
import org.w3c.dom.Document;
import org.xml.sax.ContentHandler;

public final class XMLWriter {
    private String fileEncoding;

    public XMLWriter() {
        this(System.getProperty("file.encoding"));
    }

    public XMLWriter(String string) {
        this.fileEncoding = string;
    }

    public void write(File file, XMLNode xMLNode) throws XMLException {
        try {
            XMLDocumentBuilder xMLDocumentBuilder = new XMLDocumentBuilder(xMLNode);
            Document document = xMLDocumentBuilder.build();
            this.write(file, document);
        }
        catch (Exception exception) {
            throw new XMLException(exception);
        }
    }

    public void write(File file, Document document) throws XMLException {
        try {
            String string = this.getDTD(document);
            SerializerBase serializerBase = this.getSerializerBase(file, string);
            Transformer transformer = this.getTransformer();
            transformer.transform(new DOMSource(document), new SAXResult((ContentHandler)serializerBase));
            serializerBase.getWriter().close();
        }
        catch (Exception exception) {
            throw new XMLException("writer failed to write into file. xmlFile=" + file.getPath() + " doc=" + document, exception);
        }
    }

    private SerializerBase getSerializerBase(File file, String string) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, this.fileEncoding);
        ToXMLStream toXMLStream = new ToXMLStream();
        toXMLStream.setWriter((Writer)outputStreamWriter);
        toXMLStream.setIndent(true);
        toXMLStream.setIndentAmount(4);
        toXMLStream.setEncoding(this.fileEncoding);
        if (string != null) {
            toXMLStream.setDoctypeSystem(string);
        }
        return toXMLStream;
    }

    private Transformer getTransformer() throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        return transformer;
    }

    private String getDTD(Document document) {
        String string = document.getDocumentElement().getNodeName();
        if (string.equals("xxxx")) {
            // empty if block
        }
        return null;
    }
}

