/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jeextension.cpupdate;

import java.io.File;
import java.io.IOException;
import jp.sourceforge.jeextension.common.xml.XMLException;
import jp.sourceforge.jeextension.common.xml.XMLFile;
import jp.sourceforge.jeextension.common.xml.XMLNode;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class CpUpdatePlugin
extends AbstractUIPlugin {
    private static CpUpdatePlugin plugin;

    public static CpUpdatePlugin getDefault() {
        return plugin;
    }

    public static File getReferenceFile(IProject project) {
        File file = null;
        try {
            String path = CpUpdatePlugin.load(project);
            if (path != null && !path.equals("")) {
                file = new File(path);
            }
        }
        catch (XMLException e) {
            CpUpdatePlugin.log(e);
        }
        return file;
    }

    public static void save(IProject project, String path) throws XMLException {
        XMLNode root = new XMLNode("jee-cp");
        XMLNode node = new XMLNode("reference-file");
        node.setNodeValue(path);
        root.addChild(node);
        IFile file = project.getFile(".jee-cp");
        try {
            File f = file.getLocation().toFile();
            if (!f.exists()) {
                f.createNewFile();
            }
            XMLFile xmlFile = new XMLFile(f);
            xmlFile.writeNode(root);
        }
        catch (IOException e) {
            CpUpdatePlugin.log(e);
        }
        catch (XMLException e) {
            CpUpdatePlugin.log(e);
        }
    }

    public static String load(IProject project) throws XMLException {
        IFile file = project.getFile(".jee-cp");
        if (!file.exists()) {
            return null;
        }
        XMLFile xmlFile = new XMLFile(file.getLocation().toFile());
        String path = null;
        XMLNode root = xmlFile.readNode();
        path = root.getChildNodes().getNode(0).getNodeValue();
        return path;
    }

    public static void log(Throwable e) {
        ILog log = CpUpdatePlugin.getDefault().getLog();
        String pluginId = CpUpdatePlugin.getDefault().getDescriptor().getUniqueIdentifier();
        log.log((IStatus)new Status(4, pluginId, 10001, "internal_error", e));
    }

    public CpUpdatePlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        plugin = this;
    }
}

