/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jeex.gnu.charset;

import java.nio.charset.Charset;
import java.nio.charset.spi.CharsetProvider;
import java.util.HashMap;
import java.util.Iterator;
import jp.sourceforge.jeex.gnu.charset.EUC_JP;
import jp.sourceforge.jeex.gnu.charset.MS932;
import jp.sourceforge.jeex.gnu.charset.Shift_JIS;

public class Ja_JPCharsetProvider
extends CharsetProvider {
    private final HashMap charsets = new HashMap();
    private final HashMap canonicalNames = new HashMap();

    public Ja_JPCharsetProvider() {
        this.addCharset(new EUC_JP());
        this.addCharset(new MS932());
        this.addCharset(new Shift_JIS());
    }

    private void addCharset(Charset cs) {
        String canonicalName = cs.name().toLowerCase();
        this.charsets.put(canonicalName, cs);
        this.canonicalNames.put(canonicalName, canonicalName);
        Iterator<String> i = cs.aliases().iterator();
        while (i.hasNext()) {
            String alias = i.next();
            this.canonicalNames.put(alias.toLowerCase(), canonicalName);
        }
    }

    public Charset charsetForName(String charsetName) {
        Object canonicalName = this.canonicalNames.get(charsetName.toLowerCase());
        return (Charset)this.charsets.get(canonicalName);
    }

    public Iterator charsets() {
        return this.charsets.values().iterator();
    }
}

