/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jeex.gnu.charset;

import gnu.java.nio.charset.iconv.IconvProvider;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

class MS932
extends Charset {
    MS932() {
        super("Windows-31J", new String[]{"MS932", "windows-932", "csWindows31J"});
    }

    public CharsetDecoder newDecoder() {
        Charset cs = IconvProvider.provider().charsetForName("MS932");
        return new Decoder((Charset)this, cs.newDecoder());
    }

    public CharsetEncoder newEncoder() {
        Charset cs = IconvProvider.provider().charsetForName("MS932");
        return new Encoder((Charset)this, cs.newEncoder());
    }

    public boolean contains(Charset cs) {
        return false;
    }

    private static final class Decoder
    extends CharsetDecoder {
        private CharsetDecoder iconvDecoder;

        private Decoder(Charset cs, CharsetDecoder iconvDecoder) {
            super(cs, iconvDecoder.averageCharsPerByte(), iconvDecoder.maxCharsPerByte());
            this.iconvDecoder = iconvDecoder;
        }

        protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
            int p0 = out.position();
            CoderResult result = this.iconvDecoder.decode(in, out, false);
            if (!result.isError()) {
                int p = out.position();
                int i = p0;
                while (i < p) {
                    char c = out.get(i);
                    if (c == '\u301c') {
                        out.put(i, '\uff5e');
                    } else if (c == '\u2016') {
                        out.put(i, '\u2225');
                    } else if (c == '\u2212') {
                        out.put(i, '\uff0d');
                    } else if (c == '\u00a2') {
                        out.put(i, '\uffe0');
                    } else if (c == '\u00a3') {
                        out.put(i, '\uffe1');
                    } else if (c == '\u00ac') {
                        out.put(i, '\uffe2');
                    }
                    ++i;
                }
            }
            return result;
        }
    }

    private static final class Encoder
    extends CharsetEncoder {
        private CharsetEncoder iconvEncoder;

        private Encoder(Charset cs, CharsetEncoder iconvEncoder) {
            super(cs, iconvEncoder.averageBytesPerChar(), iconvEncoder.maxBytesPerChar());
            this.iconvEncoder = iconvEncoder;
        }

        protected CoderResult encodeLoop(CharBuffer in, ByteBuffer out) {
            CharBuffer tmp = CharBuffer.allocate(in.remaining());
            int i = in.position();
            int j = 0;
            while (i < in.limit()) {
                int c = in.get(i);
                if (c == 8722) {
                    c = 65533;
                } else if (c == 8741) {
                    c = 8214;
                } else if (c == 12316) {
                    c = 65533;
                } else if (c == 65506) {
                    c = 172;
                } else if (c == 65293) {
                    c = 8722;
                } else if (c == 65374) {
                    c = 12316;
                } else if (c == 65504) {
                    c = 162;
                } else if (c == 65505) {
                    c = 163;
                } else if (c == 65506) {
                    c = 172;
                }
                tmp.put(j, (char)c);
                ++i;
                ++j;
            }
            CoderResult result = this.iconvEncoder.encode(tmp, out, false);
            int p = in.position();
            in.position(p + tmp.position());
            return result;
        }
    }
}

