/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jeextension.styleeditor.core;

import jp.sourceforge.jeextension.styleeditor.StyleEditorPlugin;
import jp.sourceforge.jeextension.styleeditor.core.ISourceViewerActivator;
import jp.sourceforge.jeextension.styleeditor.core.SourceViewerConfigurationProxyHandler;
import jp.sourceforge.jeextension.styleeditor.core.StyleEditorCore;
import jp.sourceforge.jeextension.styleeditor.core.StyleEditorTools;
import jp.sourceforge.jeextension.styleeditor.util.ProxyFactory;
import jp.sourceforge.jeextension.styleeditor.util.ReflectFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

class ActionContributorHelper
implements IPropertyChangeListener {
    private ISourceViewerActivator fActivator;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    ActionContributorHelper(ISourceViewerActivator activator) {
        this.fActivator = activator;
    }

    public void propertyChange(PropertyChangeEvent event) {
        StyleEditorCore core = StyleEditorPlugin.getDefault().getCore();
        IEditorPart part = core.getActiveEditorPart(this);
        if (part != null && part.getEditorInput() != null) {
            this.activateSourceViewer(part, true);
        }
    }

    void setActiveEditorPart(IEditorPart part) {
        StyleEditorCore core = StyleEditorPlugin.getDefault().getCore();
        if (part == null) {
            core.removeActiveEditorPart(this);
        } else {
            core.setActiveEditorPart(this, part);
            IPreferenceStore prefStore = StyleEditorPlugin.getDefault().getPreferenceStore();
            prefStore.addPropertyChangeListener((IPropertyChangeListener)this);
            this.activateSourceViewer(part, false);
            if (part instanceof ITextEditor) {
                ITextEditor editor = (ITextEditor)part;
                this.setupRulerDoubleClickAction(editor);
            }
        }
    }

    private void setupRulerDoubleClickAction(ITextEditor editor) {
        IAction action;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jface.text.source.IVerticalRulerInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IVerticalRulerInfo rulerInfo = (IVerticalRulerInfo)editor.getAdapter((Class)clazz);
        String version = StyleEditorPlugin.getRuntimeVersion();
        if (version.compareTo("3.0.2") > 0) {
            ReflectFactory factory = new ReflectFactory();
            factory.setClass("org.eclipse.debug.ui.actions.ToggleBreakpointAction");
            Class[] classArray = new Class[3];
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.ui.IWorkbenchPart");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz2;
            Class<?> clazz3 = class$2;
            if (clazz3 == null) {
                try {
                    clazz3 = class$2 = Class.forName("org.eclipse.jface.text.IDocument");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[1] = clazz3;
            Class<?> clazz4 = class$0;
            if (clazz4 == null) {
                try {
                    clazz4 = class$0 = Class.forName("org.eclipse.jface.text.source.IVerticalRulerInfo");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[2] = clazz4;
            factory.setType(classArray);
            Object[] objectArray = new Object[3];
            objectArray[0] = editor;
            objectArray[2] = rulerInfo;
            factory.setParam(objectArray);
            action = (IAction)factory.newInstance();
        } else {
            ReflectFactory factory = new ReflectFactory();
            factory.setClass("org.eclipse.jdt.internal.debug.ui.actions.ManageBreakpointRulerAction");
            Class[] classArray = new Class[2];
            Class<?> clazz5 = class$0;
            if (clazz5 == null) {
                try {
                    clazz5 = class$0 = Class.forName("org.eclipse.jface.text.source.IVerticalRulerInfo");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz5;
            Class<?> clazz6 = class$3;
            if (clazz6 == null) {
                try {
                    clazz6 = class$3 = Class.forName("org.eclipse.ui.texteditor.ITextEditor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[1] = clazz6;
            factory.setType(classArray);
            factory.setParam(new Object[]{rulerInfo, editor});
            action = (IAction)factory.newInstance();
        }
        editor.setAction("RulerDoubleClick", action);
    }

    private void activateSourceViewer(IEditorPart part, boolean force) {
        if (part == null) {
            return;
        }
        ReflectFactory factory = new ReflectFactory();
        factory.setTarget(part);
        factory.setClass("org.eclipse.ui.texteditor.AbstractTextEditor");
        factory.setName("getSourceViewer");
        ISourceViewer viewer = (ISourceViewer)factory.invoke();
        if (viewer == null) {
            return;
        }
        StyleEditorCore core = StyleEditorPlugin.getDefault().getCore();
        SourceViewerConfiguration config = core.getActiveViewerConfig(viewer);
        if (config == null || force) {
            String fileExtension = this.getFileExtension(part);
            viewer.getTextWidget().setFont(StyleEditorTools.getFont(fileExtension));
            StyleEditorTools tools = StyleEditorPlugin.getDefault().getEditorTools();
            IDocument document = viewer.getDocument();
            IDocumentPartitioner partitioner = tools.createDocumentPartitioner(fileExtension);
            partitioner.connect(document);
            if (document instanceof AbstractDocument) {
                AbstractDocument doc = (AbstractDocument)document;
                IDocumentPartitioner partitioner2 = doc.getDocumentPartitioner("___java_partitioning");
                if (partitioner2 != null) {
                    doc.setDocumentPartitioner("___java_partitioning", partitioner);
                } else {
                    doc.setDocumentPartitioner(partitioner);
                }
            } else {
                document.setDocumentPartitioner(partitioner);
            }
            Class configCls = this.getSourceViewerConfiguration(part);
            this.fActivator.activate(viewer, document, configCls, part);
        }
    }

    private Class getSourceViewerConfiguration(IEditorPart part) {
        Class target;
        ReflectFactory f = new ReflectFactory();
        f.setTarget(part);
        f.setClass("org.eclipse.ui.texteditor.AbstractTextEditor");
        f.setName("getSourceViewerConfiguration");
        Object sourceViewerConfig = f.invoke();
        String fileExtension = this.getFileExtension(part);
        SourceViewerConfigurationProxyHandler handler = new SourceViewerConfigurationProxyHandler(sourceViewerConfig);
        handler.setFileExtension(fileExtension);
        ClassLoader loader = this.getClass().getClassLoader();
        try {
            ProxyFactory proxyFactory = new ProxyFactory(loader);
            proxyFactory.setSuperclass(sourceViewerConfig.getClass());
            proxyFactory.setHandler(handler);
            target = proxyFactory.createClass();
        }
        catch (Exception e) {
            StyleEditorPlugin.log(e);
            target = null;
        }
        return target;
    }

    private String getFileExtension(IEditorPart part) {
        IEditorInput input = part.getEditorInput();
        String fileName = input.getName();
        String fileExtension = fileName.lastIndexOf(".") != -1 ? fileName.substring(fileName.lastIndexOf(".") + 1, fileName.length()) : "*";
        return fileExtension;
    }
}

