/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jeextension.styleeditor.core;

import java.util.HashMap;
import jp.sourceforge.jeextension.styleeditor.core.ActionContributorHelper;
import jp.sourceforge.jeextension.styleeditor.core.StyleEditorColorManager;
import jp.sourceforge.jeextension.styleeditor.core.StyleEditorTools;
import org.eclipse.jdt.ui.text.IColorManager;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.ui.IEditorPart;

public class StyleEditorCore {
    private HashMap fActiveEditorCache = new HashMap();
    private HashMap fActiveConfigCache = new HashMap();
    private StyleEditorTools fEditorTools;
    private IColorManager fColorManager;

    public synchronized StyleEditorTools getEditorTools() {
        if (this.fEditorTools == null) {
            this.fEditorTools = new StyleEditorTools();
        }
        return this.fEditorTools;
    }

    public synchronized IColorManager getColorManager() {
        if (this.fColorManager == null) {
            this.fColorManager = new StyleEditorColorManager();
        }
        return this.fColorManager;
    }

    public IEditorPart getActiveEditorPart(ActionContributorHelper contrib) {
        return (IEditorPart)this.fActiveEditorCache.get(contrib);
    }

    public void setActiveEditorPart(ActionContributorHelper contrib, IEditorPart editor) {
        this.fActiveEditorCache.put(contrib, editor);
    }

    public void removeActiveEditorPart(ActionContributorHelper contrib) {
        this.fActiveEditorCache.remove(contrib);
    }

    public SourceViewerConfiguration getActiveViewerConfig(ISourceViewer viewer) {
        return (SourceViewerConfiguration)this.fActiveConfigCache.get(viewer);
    }

    public void setActiveViewerConfig(ISourceViewer viewer, SourceViewerConfiguration config) {
        this.fActiveConfigCache.put(viewer, config);
    }

    public void removeActiveViewerConfig(ISourceViewer viewer) {
        this.fActiveConfigCache.remove(viewer);
    }

    public void dispose() {
        this.fActiveEditorCache.clear();
        this.fActiveConfigCache.clear();
        this.fColorManager.dispose();
    }
}

