/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jeextension.styleeditor.entry;

import jp.sourceforge.jeextension.common.xml.XMLNode;
import jp.sourceforge.jeextension.styleeditor.core.StyleEditorTools;
import jp.sourceforge.jeextension.styleeditor.entry.DependsEntryList;
import jp.sourceforge.jeextension.styleeditor.entry.IPartitionEntry;
import jp.sourceforge.jeextension.styleeditor.text.IExtRule;
import org.eclipse.swt.graphics.RGB;

public class PartitionEntry
implements IPartitionEntry {
    private String fEnd = "";
    private String fName = "";
    private RGB fRGB = new RGB(0, 0, 0);
    private RGB fBgRGB = new RGB(255, 255, 255);
    private boolean fBgColor = false;
    private boolean fItalic = false;
    private boolean fBold = false;
    private boolean fStrikeThrough = false;
    private boolean fUnderline = false;
    private IExtRule fRule;
    private String fStart = "";
    private String fRegExp = "";
    private DependsEntryList fDepends = new DependsEntryList();
    private String fView;

    public PartitionEntry() {
    }

    public PartitionEntry(XMLNode node, String ext) {
        this.fName = node.getAttribute("name");
        this.fStart = node.getAttribute("start");
        this.fEnd = node.getAttribute("end");
        this.fRegExp = node.getAttribute("regexp");
        this.fRGB.red = Integer.parseInt(node.getAttribute("red"));
        this.fRGB.green = Integer.parseInt(node.getAttribute("green"));
        this.fRGB.blue = Integer.parseInt(node.getAttribute("blue"));
        this.fBgColor = Boolean.valueOf(node.getAttribute("bgcolor"));
        if (this.fBgColor) {
            this.fBgRGB.red = Integer.parseInt(node.getAttribute("bred"));
            this.fBgRGB.green = Integer.parseInt(node.getAttribute("bgreen"));
            this.fBgRGB.blue = Integer.parseInt(node.getAttribute("bblue"));
        }
        this.fItalic = Boolean.valueOf(node.getAttribute("italic"));
        this.fBold = Boolean.valueOf(node.getAttribute("bold"));
        this.fStrikeThrough = Boolean.valueOf(node.getAttribute("strikethrough"));
        this.fUnderline = Boolean.valueOf(node.getAttribute("underline"));
        if (this.fRegExp == null) {
            this.fRegExp = "";
        }
        this.fView = !this.fRegExp.equals("") ? this.fRegExp : String.valueOf(this.fStart) + " " + this.fEnd;
        this.setName(this.fName);
        if (this.fName.equals("__dftl_partition_content_type")) {
            return;
        }
        this.fRule = StyleEditorTools.createExtRule(node, ext);
    }

    public XMLNode createNode() {
        XMLNode xmlNode = new XMLNode("partition");
        xmlNode.setAttribute("name", this.fName);
        xmlNode.setAttribute("red", String.valueOf(this.fRGB.red));
        xmlNode.setAttribute("green", String.valueOf(this.fRGB.green));
        xmlNode.setAttribute("blue", String.valueOf(this.fRGB.blue));
        xmlNode.setAttribute("start", this.getStart());
        xmlNode.setAttribute("end", this.getEnd());
        xmlNode.setAttribute("regexp", this.getRegExp());
        if (this.fBgColor) {
            xmlNode.setAttribute("bgcolor", "true");
            xmlNode.setAttribute("bred", String.valueOf(this.fBgRGB.red));
            xmlNode.setAttribute("bgreen", String.valueOf(this.fBgRGB.green));
            xmlNode.setAttribute("bblue", String.valueOf(this.fBgRGB.blue));
        } else {
            xmlNode.setAttribute("bgcolor", "false");
            xmlNode.setAttribute("bred", "");
            xmlNode.setAttribute("bgreen", "");
            xmlNode.setAttribute("bblue", "");
        }
        xmlNode.setAttribute("italic", String.valueOf(this.fItalic));
        xmlNode.setAttribute("bold", String.valueOf(this.fBold));
        xmlNode.setAttribute("strikethrough", String.valueOf(this.fStrikeThrough));
        xmlNode.setAttribute("underline", String.valueOf(this.fUnderline));
        return xmlNode;
    }

    public String getEnd() {
        return this.fEnd;
    }

    public String getName() {
        return this.fName;
    }

    public RGB getRGB() {
        return this.fRGB;
    }

    public IExtRule getRule() {
        return this.fRule;
    }

    public String getStart() {
        return this.fStart;
    }

    public DependsEntryList getDependsEntryList() {
        return this.fDepends;
    }

    public void setEnd(String string) {
        this.fEnd = string;
    }

    public void setName(String string) {
        this.fName = string.equals("__dftl_partition_content_type") ? "__dftl_partition_content_type" : (string.equals("__java_javadoc") ? "__java_javadoc" : (string.equals("__java_multiline_comment") ? "__java_multiline_comment" : (string.equals("__java_singleline_comment") ? "__java_singleline_comment" : string)));
    }

    public void setRGB(RGB newRgb) {
        this.fRGB = newRgb;
    }

    public void setRule(IExtRule rule) {
        this.fRule = rule;
    }

    public void setStart(String string) {
        this.fStart = string;
    }

    public String getRegExp() {
        return this.fRegExp;
    }

    public void setRegExp(String regexp) {
        this.fRegExp = regexp;
    }

    public String getView() {
        return this.fView;
    }

    public void setView(String view) {
        this.fView = view;
    }

    public RGB getBgRGB() {
        return this.fBgRGB;
    }

    public boolean isBgColor() {
        return this.fBgColor;
    }

    public boolean isBold() {
        return this.fBold;
    }

    public boolean isItalic() {
        return this.fItalic;
    }

    public boolean isStrikeThrough() {
        return this.fStrikeThrough;
    }

    public boolean isUnderline() {
        return this.fUnderline;
    }

    public void setBgColor(boolean b) {
        this.fBgColor = b;
    }

    public void setBgRGB(RGB rgb) {
        this.fBgRGB = rgb;
    }

    public void setBold(boolean b) {
        this.fBold = b;
    }

    public void setItalic(boolean b) {
        this.fItalic = b;
    }

    public void setStrikeThrough(boolean b) {
        this.fStrikeThrough = b;
    }

    public void setUnderline(boolean b) {
        this.fUnderline = b;
    }
}

