/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jeextension.styleeditor.preferences;

import java.util.Map;
import jp.sourceforge.jeextension.common.plugin.DefaultDialog;
import jp.sourceforge.jeextension.styleeditor.core.StyleEditorTools;
import jp.sourceforge.jeextension.styleeditor.entry.FontEntry;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

class AddExtensionDialog
extends DefaultDialog
implements SelectionListener {
    private Label fLabelExt;
    private String[] fExtContainer;
    private Text fTextExt;
    private Button fButtonFont;
    private Label fLabelFont;
    private String fExtension;
    private Shell fShell;
    private FontData fFontData;

    AddExtensionDialog(Shell shell, String[] container) {
        super(shell);
        this.fShell = shell;
        this.fExtension = container[0];
        this.fExtContainer = container;
        Font font = StyleEditorTools.getFont(this.fExtension);
        this.fFontData = font.getFontData()[0];
    }

    public void handleEvent(Event event) {
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        this.fLabelExt = new Label(composite, 0);
        this.fLabelExt.setText(this.getMessage("pref.extension.dlg.label"));
        this.fTextExt = new Text(composite, 2048);
        this.fTextExt.setLayoutData((Object)new GridData(768));
        if (this.fExtension != null) {
            this.fTextExt.setText(this.fExtension);
        }
        this.fLabelFont = new Label(composite, 0);
        this.fLabelFont.setText(String.valueOf(this.fFontData.getName()) + ", " + this.fFontData.getHeight());
        GridData gridData1 = new GridData();
        gridData1.horizontalSpan = 2;
        this.fLabelFont.setLayoutData((Object)gridData1);
        this.fButtonFont = new Button(composite, 0);
        this.fButtonFont.setText(this.getMessage("pref.extension.dlg.font"));
        this.fButtonFont.addSelectionListener((SelectionListener)this);
        return composite;
    }

    protected void okPressed() {
        Map fontEntryMap;
        FontEntry fontEntry;
        String newExt = this.fTextExt.getText();
        Map map = StyleEditorTools.getPartitionEntryMap();
        Object obj = map.get(newExt);
        if (obj == null && !newExt.equals("")) {
            StyleEditorTools.getPartitionEntryList(newExt, true);
            Object old = map.get(this.fExtContainer[0]);
            if (old != null) {
                map.remove(this.fExtContainer[0]);
                map.put(newExt, old);
            }
        }
        if ((fontEntry = (FontEntry)(fontEntryMap = StyleEditorTools.getFontEntryMap()).get(this.fExtension)) != null) {
            fontEntry.setName(this.fFontData.getName());
            fontEntry.setSize(this.fFontData.getHeight());
        } else {
            fontEntry = new FontEntry(this.fFontData.getName(), String.valueOf(this.fFontData.getHeight()));
            fontEntryMap.put(this.fExtension, fontEntry);
        }
        this.fExtContainer[0] = newExt;
        super.okPressed();
    }

    public void widgetSelected(SelectionEvent ev) {
        if (ev.widget == this.fButtonFont) {
            FontDialog d = new FontDialog(this.fShell);
            d.setFontList(new FontData[]{this.fFontData});
            FontData fontData = d.open();
            if (fontData != null) {
                this.fFontData = fontData;
                this.fLabelFont.setText(String.valueOf(this.fFontData.getName()) + ", " + this.fFontData.getHeight());
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent ev) {
    }
}

