/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jeextension.styleeditor.text;

import java.util.Iterator;
import java.util.Map;
import jp.sourceforge.jeextension.styleeditor.text.IColorActivator;
import jp.sourceforge.jeextension.styleeditor.text.IExtRule;
import org.eclipse.jdt.ui.text.IColorManager;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;

public class ExtWordRule
extends WordRule
implements IExtRule {
    private String fWord;
    private String fCase;
    private StringBuffer fBuffer = new StringBuffer();

    public ExtWordRule(IWordDetector detector) {
        super(detector);
    }

    public ExtWordRule(IWordDetector detector, IToken defaultToken) {
        super(detector, defaultToken);
    }

    public void activateColor(IColorManager cm) {
        Object obj = this.fDefaultToken.getData();
        if (obj instanceof IColorActivator) {
            ((IColorActivator)obj).activateColor(cm);
        }
        Iterator iterator = this.fWords.values().iterator();
        while (iterator.hasNext()) {
            IToken token = (IToken)iterator.next();
            obj = token.getData();
            if (!(obj instanceof IColorActivator)) continue;
            ((IColorActivator)obj).activateColor(cm);
        }
    }

    public void addWord(String word, IToken token, String sensitive) {
        super.addWord(word, token);
        this.fWord = word;
        this.fCase = sensitive;
        if (this.fCase.equalsIgnoreCase("false")) {
            String upper = word.toUpperCase();
            String lower = word.toLowerCase();
            this.addWord(upper, token);
            this.addWord(lower, token);
        }
    }

    public void addWordRuleMap(Map wordRuleMap) {
        this.fWords.putAll(wordRuleMap);
    }

    public Map getWordRuleMap() {
        return this.fWords;
    }

    public String[] getWords() {
        return new String[]{this.fWord, this.fCase};
    }

    public void setWords(String[] words) {
        String keyword = words[0];
        String casesesitive = words[1];
        IToken token = (IToken)this.fWords.remove(keyword);
        this.addWord(keyword, token, casesesitive);
    }

    public IToken evaluate(ICharacterScanner scanner) {
        int c = scanner.read();
        if (this.fDetector.isWordStart((char)c) && (this.fColumn == -1 || this.fColumn == scanner.getColumn() - 1)) {
            this.fBuffer.setLength(0);
            do {
                this.fBuffer.append((char)c);
            } while (this.isContinue(c = scanner.read()));
            scanner.unread();
            IToken token = (IToken)this.fWords.get(this.fBuffer.toString());
            if (token != null) {
                return token;
            }
            if (this.fDefaultToken.isUndefined()) {
                this.unreadBuffer(scanner);
            }
            return this.fDefaultToken;
        }
        scanner.unread();
        return Token.UNDEFINED;
    }

    private boolean isContinue(int c) {
        return c != -1 && this.fDetector.isWordPart((char)c);
    }
}

