/* ****************************************************************************
 * Copyright (c) 2002 Java Eclipse Extension Project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.opensource.org/licenses/cpl.php
 * ============================================================================
 * $Header: /cvsroot/jeextension/jp.sourceforge.jeextension.styleeditor/src/jp/sourceforge/jeextension/styleeditor/core/TextStyleEditorActionContributor.java,v 1.3 2007/09/12 05:00:41 kohnosuke Exp $
 * $Revision: 1.3 $
 * $Date: 2007/09/12 05:00:41 $
 * ============================================================================
 * ***************************************************************************/
package jp.sourceforge.jeextension.styleeditor.core;

import java.lang.reflect.Constructor;

import jp.sourceforge.jeextension.styleeditor.StyleEditorPlugin;
import jp.sourceforge.jeextension.styleeditor.util.ReflectFactory;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.ISourceViewerExtension2;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.editors.text.TextEditorActionContributor;

/**
 * ActionContributor for TextStyleEditor.
 * @since 2.0.0
 */
public class TextStyleEditorActionContributor extends
        TextEditorActionContributor implements ISourceViewerActivator {
    
    /** ActionContributorHelper */
    private ActionContributorHelper fHelper;
    
    /**
     * Default Constructor.
     */
    public TextStyleEditorActionContributor() {
        super();
        fHelper = new ActionContributorHelper(this);
    }
    
    /**
     * {@inheritDoc}
     */
    public void setActiveEditor(IEditorPart part) {
        fHelper.setActiveEditorPart(part);
        super.setActiveEditor(part);
    }
    
    /**
     * {@inheritDoc}
     */
    public void activate(ISourceViewer viewer, IDocument document,
            Class sourceViewerClass, IEditorPart part) {
        
        ReflectFactory f = new ReflectFactory();
        
        // IPreferenceStore
        f.setTarget(part);
        f.setClass("org.eclipse.ui.texteditor.AbstractTextEditor");
        f.setName("getPreferenceStore");
        Object preferenceStore = f.invoke();
        
        // SourceViewerConfiguration instance
        Object instance = null;
        try {
            Constructor con = sourceViewerClass.getConstructor(new Class[] {
                    IPreferenceStore.class,
            });
            instance = con.newInstance(new Object[] {
                    preferenceStore,
            });
        }
        catch (Exception e) {
            StyleEditorPlugin.log(e);
        }
        
        // configure
        if (viewer instanceof ISourceViewerExtension2) {
            ((ISourceViewerExtension2) viewer).unconfigure();
            viewer.configure((SourceViewerConfiguration) instance);
        }
        
        // repaint
        viewer.setDocument(document, viewer.getAnnotationModel());
    }
}
