/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jeextension.styleeditor.text;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class RegExpRule
implements IPredicateRule {
    protected IToken fToken;
    protected Pattern fPattern;

    public RegExpRule(String regexp, IToken token) {
        this.fToken = token;
        this.fPattern = Pattern.compile(regexp);
    }

    public IToken evaluate(ICharacterScanner scanner) {
        int c = scanner.read();
        scanner.unread();
        if (c != -1) {
            String line = this.readToEOL(scanner);
            Matcher m = this.fPattern.matcher(line);
            if (m.find()) {
                String match = m.group();
                int start = m.start();
                if (start == 0 && match.length() > 0) {
                    this.unread(line.length() - m.end(), scanner);
                    return this.fToken;
                }
            }
            this.unread(line.length(), scanner);
        }
        return Token.UNDEFINED;
    }

    protected void unread(int size, ICharacterScanner scanner) {
        int i = 0;
        while (i < size) {
            scanner.unread();
            ++i;
        }
    }

    protected String readToEOL(ICharacterScanner scanner) {
        StringBuffer sb = new StringBuffer();
        boolean lineBreakDetected = false;
        while (true) {
            int i = scanner.read();
            char c = (char)i;
            if (i == -1) {
                scanner.unread();
                break;
            }
            if (c != '\n' && c != '\n' && lineBreakDetected) {
                scanner.unread();
                break;
            }
            if (c == '\r') {
                lineBreakDetected = true;
            }
            if (c == '\n') {
                lineBreakDetected = true;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        return this.evaluate(scanner);
    }

    public IToken getSuccessToken() {
        return this.fToken;
    }
}

