/* ****************************************************************************
 * Copyright (c) 2002 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 * 
 * Contributors:
 * IBM - Initial API and implementation
 * 
 * ============================================================================
 * Eclipse Extension Plug-in Project
 * 
 * $Header: 
 * $Revision: 
 * $Date: 
 * ============================================================================
 * ***************************************************************************/
package jp.sourceforge.jeextension.jspc.popup.actions;

import java.lang.reflect.InvocationTargetException;

import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

public class JspCAction implements IObjectActionDelegate {

	/**
	 * Constructor for Action1.
	 */
	public JspCAction() {
		super();
	}

	/**
	 * @see IObjectActionDelegate#setActivePart(IAction, IWorkbenchPart)
	 */
	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
	}

	/**
	 * @see IActionDelegate#run(IAction)
	 */
	public void run(IAction action) {

        IWorkbenchWindow window= JavaPlugin.getActiveWorkbenchWindow();
        ISelection selection= window.getSelectionService().getSelection();
		
        if ((selection instanceof IStructuredSelection) == false) {
            return;
        }
        Object obj = ((IStructuredSelection)selection).getFirstElement();
        
        
        
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(null);
        JspCRunner runnable = new JspCRunner(obj);
        
        try {
            dialog.run(true, true, runnable);
        } catch (InvocationTargetException e) {
            e.printStackTrace();
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        
        if (runnable.occuredThrowable != null) {
            showMessage(runnable.occuredThrowable);
        }
        
	}

	/**
	 * @see IActionDelegate#selectionChanged(IAction, ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {
	}

    static void showMessage(Throwable e) {
        Shell shell = new Shell();
        MessageDialog.openWarning(shell, "Warning", e.getMessage());
        return;
    }

}
