/* ****************************************************************************
 * Copyright (c) 2002 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 * 
 * Contributors:
 * IBM - Initial API and implementation
 * 
 * ============================================================================
 * Eclipse Extension Plug-in Project
 * 
 * $Header: 
 * $Revision: 
 * $Date: 
 * ============================================================================
 * ***************************************************************************/
package jp.sourceforge.jeextension.jspc;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.JavaRuntime;

/**
 * Util
 */
public class Util {
    /**
     * Return project class-path.
     * @param project
     * @return
     */
    public static String getProjectClassPath(IProject project) {
        String classPath = "";
        try {
            String[] cp = JavaRuntime.computeDefaultRuntimeClassPath(
                                    JavaCore.create(project));
            for (int i = 0; i < cp.length; i++) {
                classPath = classPath + cp[i] + ";";
            }
        } catch (CoreException e) {
            e.printStackTrace();
        }
        return classPath;
    }
}
