/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlProperty
extends Task {
    private File src;
    private String prefix = "";
    private boolean keepRoot = true;
    private boolean validate = false;
    private boolean collapseAttributes = false;
    private Document document;

    public void init() {
        super.init();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        BufferedInputStream configurationStream = null;
        try {
            try {
                configurationStream = new BufferedInputStream(new FileInputStream(this.src));
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setValidating(this.validate);
                factory.setNamespaceAware(false);
                DocumentBuilder builder = factory.newDocumentBuilder();
                this.document = builder.parse(configurationStream);
                Element topElement = this.document.getDocumentElement();
                NodeList topChildren = topElement.getChildNodes();
                int numChildren = topChildren.getLength();
                this.log("Using prefix: \"" + this.prefix + "\"", 4);
                if (this.keepRoot) {
                    this.addNodeRecursively(topElement, this.prefix);
                } else {
                    for (int i = 0; i < numChildren; ++i) {
                        this.addNodeRecursively(topChildren.item(i), this.prefix);
                    }
                }
                Object var9_12 = null;
                if (configurationStream == null) return;
            }
            catch (SAXException sxe) {
                Exception x = sxe;
                if (sxe.getException() == null) throw new BuildException(x);
                x = sxe.getException();
                throw new BuildException(x);
            }
            catch (ParserConfigurationException pce) {
                throw new BuildException(pce);
            }
            catch (IOException ioe) {
                throw new BuildException(ioe);
            }
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            if (configurationStream == null) throw throwable;
            try {
                configurationStream.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        configurationStream.close();
        return;
    }

    void addNodeRecursively(Node node, String prefix) {
        String nodeText;
        if (node.hasAttributes()) {
            NamedNodeMap nodeAttributes = node.getAttributes();
            for (int i = 0; i < nodeAttributes.getLength(); ++i) {
                Node attributeNode = nodeAttributes.item(i);
                String attributeName = this.collapseAttributes ? prefix + (prefix.trim().equals("") ? "" : ".") + node.getNodeName() + "." + attributeNode.getNodeName() : prefix + (prefix.trim().equals("") ? "" : ".") + node.getNodeName() + "(" + attributeNode.getNodeName() + ")";
                String attributeValue = attributeNode.getNodeValue();
                this.log(attributeName + ":" + attributeValue, 4);
                this.project.setNewProperty(attributeName, attributeValue);
            }
        }
        if (node.getNodeType() == 3 && (nodeText = node.getNodeValue()).trim().length() != 0) {
            this.log(prefix + ":" + nodeText, 4);
            this.project.setNewProperty(prefix, nodeText);
        }
        if (node.hasChildNodes()) {
            prefix = prefix + (prefix.trim().equals("") ? "" : ".") + node.getNodeName();
            NodeList nodeChildren = node.getChildNodes();
            int numChildren = nodeChildren.getLength();
            for (int i = 0; i < numChildren; ++i) {
                this.addNodeRecursively(nodeChildren.item(i), prefix);
            }
        }
    }

    public void setFile(File src) {
        this.src = src;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix.trim();
    }

    public void setKeeproot(boolean keepRoot) {
        this.keepRoot = keepRoot;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    public void setCollapseAttributes(boolean collapseAttributes) {
        this.collapseAttributes = collapseAttributes;
    }
}

