﻿using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;
using J_ColPicker;

namespace ColPicker
{
    /// <summary>
    /// This is the main type for your game
    /// </summary>
    public class Game1 : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;
        SpriteBatch spriteBatch;

        /// <summary>カラーピッカーIMG</summary>
        Texture2D colPic_back;
        /// <summary>ピックアップ選択用の丸</summary>
        Texture2D sel_maru;
        /// <summary>選択中色の表示用のダミー画像</summary>
        Texture2D img_w;

        /// <summary>現在選択中のピッカーポイント</summary>
        Point NowSelPickPoint = new Point(0, 0);
        /// <summary>
        /// 選択用の丸画像の半分の大きさを格納する
        /// (中心に描画するため）
        /// </summary>
        Point maru_Harf;

        SpriteFont sp14;

        /// <summary>
        /// 重要な値：ピッカーIMG作成時に指定した倍率です。
        /// WinFormにて色テーブル画像を作成した際、しっかり覚えて置いてください。
        /// 画像の大きさから導き出せないことも無いですが。
        /// </summary>
        float[] PickPow;

        public Game1()
        {
            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";
        }

        /// <summary>
        /// Allows the game to perform any initialization it needs to before starting to run.
        /// This is where it can query for any required services and load any non-graphic
        /// related content.  Calling base.Initialize will enumerate through any components
        /// and initialize them as well.
        /// </summary>
        protected override void Initialize()
        {
            // TODO: Add your initialization logic here

            base.Initialize();
        }

        /// <summary>
        /// LoadContent will be called once per game and is the place to load
        /// all of your content.
        /// </summary>
        protected override void LoadContent()
        {
            // Create a new SpriteBatch, which can be used to draw textures.
            spriteBatch = new SpriteBatch(GraphicsDevice);

            // TODO: use this.Content to load your game content here

            //各種コンテントのロード
            colPic_back = Content.Load<Texture2D>("PickerImg");
            PickPow = new float[] { 0.25f, 0.25f };

            sel_maru = Content.Load<Texture2D>("maru_sml");

            img_w = Content.Load<Texture2D>("w"); 

            maru_Harf = new Point(sel_maru.Width / 2, sel_maru.Height / 2);

            sp14 = Content.Load<SpriteFont>("SpriteFont1");
        }

        /// <summary>
        /// UnloadContent will be called once per game and is the place to unload
        /// all content.
        /// </summary>
        protected override void UnloadContent()
        {
            // TODO: Unload any non ContentManager content here
        }

        /// <summary>
        /// Allows the game to run logic such as updating the world,
        /// checking for collisions, gathering input, and playing audio.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Update(GameTime gameTime)
        {
            // Allows the game to exit
            if (GamePad.GetState(PlayerIndex.One).Buttons.Back == ButtonState.Pressed)
                this.Exit();

            // TODO: Add your update logic here
            
            //PCキーボードでの操作
            KeyboardState keyState = Keyboard.GetState();

            Point moment = new Point();


            //上下
            if (keyState.IsKeyDown(Keys.Up) || keyState.IsKeyDown(Keys.W))
            {
                moment.Y = -1;
            }
            if (keyState.IsKeyDown(Keys.Down) || keyState.IsKeyDown(Keys.S))
            {
                moment.Y = +1;
            }
            
            //左右
            if (keyState.IsKeyDown(Keys.Left) || keyState.IsKeyDown(Keys.A))
            {
                moment.X = -1;
            }
            if (keyState.IsKeyDown(Keys.Right) || keyState.IsKeyDown(Keys.D))
            {
                moment.X = +1;
            }

            //Shiftが押されていたら、２倍速度に
            if (keyState.IsKeyDown(Keys.LeftShift))
            {
                moment.X *= 2; moment.Y *= 2;
            }

            //座標確定
            NowSelPickPoint.Y = (int)MathHelper.Clamp(NowSelPickPoint.Y + moment.Y, 0, colPic_back.Height);
            NowSelPickPoint.X += moment.X;

            //X軸は左右ループ
            if (NowSelPickPoint.X < 0) NowSelPickPoint.X = colPic_back.Width - 1;
            if (NowSelPickPoint.X >= colPic_back.Width) NowSelPickPoint.X = 0;

            base.Update(gameTime);
        }

        /// <summary>
        /// This is called when the game should draw itself.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Draw(GameTime gameTime)
        {
            GraphicsDevice.Clear(Color.CornflowerBlue);

            // TODO: Add your drawing code here
            spriteBatch.Begin(SpriteSortMode.Immediate, BlendState.AlphaBlend);

            //カラーピッカー背景（サンプル）の描画
            spriteBatch.Draw(colPic_back,new Rectangle(200,200,colPic_back.Width,colPic_back.Height),Color.White);

            //選択カーソルの描画
            spriteBatch.Draw(sel_maru, new Rectangle(200 + NowSelPickPoint.X - maru_Harf.X,
                                                     200 + NowSelPickPoint.Y - maru_Harf.Y, 
                                                     sel_maru.Width, sel_maru.Height),
                             Color.White);

            //カラーを取得
            Color nowCol = clsPickerData.PickerXYtoRGB(ref NowSelPickPoint, ref PickPow);
            //選択中の色の拡大表示
            spriteBatch.Draw(img_w, new Rectangle(250,100, 64, 64),nowCol);


            //色のRGB表示（文字で）
            spriteBatch.DrawString(sp14, "value-R:" + nowCol.R.ToString(), new Vector2(150, 350), Color.White);
            spriteBatch.DrawString(sp14, "value-G:" + nowCol.G.ToString(), new Vector2(150, 370), Color.White);
            spriteBatch.DrawString(sp14, "value-B:" + nowCol.B.ToString(), new Vector2(150, 390), Color.White);



            spriteBatch.End();
            base.Draw(gameTime);
        }
    }
}
