<?php
/**
 * アクティブセッションクラス
 * @author: Tomohiro Suzuki <suzuki@freepg.jp>
 */
/* vim: set expandtab sw=4 ts=4 sts=4 fdm=marker: */

class ClassActiveSession
{
    // ● メンバー変数
    ///*{{{*/
    public $fileSession = "";
    public $arr = array();
    ///*}}}*/
    
    // ● コンストラクタ
    public function __construct($id)/*{{{*/
    {
        $this->fileSession = DIR_ACTIVE_SESSION . md5($id);
        if (file_exists($this->fileSession)) {
            if ($fp = @fopen($this->fileSession, "r")) {
                flock($fp, LOCK_SH);
                while (!feof($fp)) {
                    $line = @fgets($fp);
                    $line = trim($line);
                    if ($line !== "") {
                        $tmp = mb_split("=", $line);
                        $this->arr[urldecode($tmp[0])] = urldecode($tmp[1]);
                    }
                }
                flock($fp, LOCK_UN);
                @fclose($fp);
            }
        }
    }/*}}}*/
    
    // ● 初期化
    public function init()/*{{{*/
    {
        $this->arr = array();
        if ($fp = @fopen($this->fileSession, "w")) {
            @fclose($fp);
        }
    }/*}}}*/
    
    // ● セット
    public function set($key, $value)/*{{{*/
    {
        $this->arr[$key] = $value;
        if ($fp = @fopen($this->fileSession, "w")) {
            flock($fp, LOCK_EX);
            foreach ($this->arr as $key => $value) {
                $line = sprintf("%s=%s\n", urlencode($key), urlencode($value));
                @fwrite($fp, $line);
            }
            flock($fp, LOCK_UN);
            @fclose($fp);
        }
    }/*}}}*/
    
    // ● ゲット
    public function get($key)/*{{{*/
    {
        return $this->arr[$key];
    }/*}}}*/
    
    // ● データの全取得
    public function getAll()/*{{{*/
    {
        return $this->arr;
    }/*}}}*/
}

