<?php

/**
 * メール用クラス
 * @author: Tomohiro Suzuki <suzuki@freepg.jp>
 */
/* vim: set expandtab sw=4 ts=4 sts=4 fdm=marker: */

class ClassMail
{
    // ● メンバー変数
    ///*{{{*/
    // ヘッダ情報（通常は変更を加えないこと）
    protected $header = "";
    
    // 送信者のヘッダ情報（通常は変更を加えないこと）
    protected $from = "";
    // 送信者の名前（日本語）
    protected $fromName = "";
    // 送信者のメールアドレス
    protected $fromAddr = "";
    
    // 受信者のヘッダ情報（通常は変更を加えないこと）
    protected $to = "";
    // 受信者の名前（日本語）
    protected $toName = "";
    // 受信者のメールアドレス
    protected $toAddr = "";
    
    // 返信先のメールアドレス
    protected $replyTo = "";
    // リターンメールの送信先
    protected $returnTo = "";
    
    // メールの件名
    protected $subject = "";
    // メールの本文
    protected $message = "";
    
    // 添付ファイル（カレントディレクトリに存在する場合でも ./ は必ず付けるように）
    protected $upfile = "";
    // 添付ファイルのＭＩＭＥタイプ
    protected $upfileType = "";
    // ＭＩＭＥタイプ情報を記述しているファイル
    protected $mimeFile = "";
    
    // 全体の文字コード（ASCII, JIS, UTF-8, EUC-JP, SJIS）
    protected $charCode = CHAR_CODE_PHP;
    // メールの文字コード（JISで固定）
    protected $charMail = "JIS";
    ///*}}}*/
    
    // ● コンストラクタ
    public function __construct()/*{{{*/
    {
        $this->setFromName($this->fromName);
        $this->setToName($this->toName);
        $this->setFromAddr($this->fromAddr);
        $this->setToAddr($this->toAddr);
    }/*}}}*/

    // ● テキストメール送信
    public function sendTxtMail()/*{{{*/
    {
        $this->header = "";
        $this->setHeader();
        $this->subject = "=?iso-2022-jp?B?" . base64_encode(mb_convert_encoding($this->subject, $this->charMail, $this->charCode)) . "?=";
        $this->message = @mb_convert_encoding($this->message, $this->charMail, $this->charCode);
        return @mail($this->to, $this->subject, $this->message, $this->header);
    }/*}}}*/
    
    // ● ＨＴＭＬメール送信
    public function sendHtmlMail()/*{{{*/
    {
        $this->header = "";
        $this->setHeader();
        $this->header .= 'MIME-version: 1.0' . "\r\n";
        $this->header .= 'Content-type: text/html; charset=ISO-2022-JP' . "\r\n";
        $this->subject = "=?iso-2022-jp?B?" . base64_encode(mb_convert_encoding($this->subject, $this->charMail, $this->charCode)) . "?=";
        $this->message = @mb_convert_encoding($this->message, $this->charMail, $this->charCode);
        return @mail($this->to, $this->subject, $this->message, $this->header);
    }/*}}}*/
    
    // ● 添付メール送信（HTML）
    public function sendAttachMail()/*{{{*/
    {
        // バウンダリー文字
        $boundary = md5(uniqid(rand()));
        
        $this->header = "";
        $this->setHeader();
        $this->header .= 'X-Mailer: PHP' . "\r\n";
        $this->header .= 'MIME-version: 1.0' . "\r\n";
        $this->header .= "Content-Type: multipart/mixed;\r\n";
        $this->header .= sprintf("\tboundary=\"%s\"\r\n", $boundary);
        
        $message = @mb_convert_encoding($this->message, $this->charMail, $this->charCode);
        
        $msg = "";
        $msg .= "This is a multi-part message in MIME format.\n\n";
        $msg .= sprintf("--%s\n", $boundary);
        $msg .= 'Content-type: text/html; charset=ISO-2022-JP' . "\r\n";
        $msg .= "Content-Transfer-Encoding: 7bit\n\n";
        $msg .= sprintf("%s \n", $message);
        
        $fp = @fopen($this->upfile, "r");
        if ($fp == FALSE) {
            return FALSE;
        }
        $contents = @fread($fp, filesize($this->upfile));
        @fclose($fp);
        
        //エンコードして分割
        $fileEncoded = @chunk_split(base64_encode($contents));
        
        $arrName = explode("/", $this->upfile);
        $index = count($arrName) - 1;
        $upfileName = $arrName[$index];
        
        $this->upfileType = "";
        
        $arrName = explode(".", $upfileName);
        $index = count($arrName) - 1;
        
        // 添付ファイルの拡張子からMIMEヘッダを取得
        $extensionName = $arrName[$index];
        $this->upfileType = $this->getMime($extensionName);
        $flgFind = TRUE;
        if ($flgFind == FALSE) {
            return FALSE;
        }
        
        $msg .= sprintf("\n\n--%s\n", $boundary);
        $msg .= sprintf("Content-Type: %s;\n", $this->upfileType);
        $msg .= sprintf("\tname=\"%s\"\n", $upfileName);
        $msg .= "Content-Transfer-Encoding: base64\n";
        $msg .= "Content-Disposition: attachment;\n";
        $msg .= sprintf("\tfilename=\"%s\"\n\n", $upfileName);
        $msg .= sprintf("%s\n", $fileEncoded);
        $msg .= sprintf("--%s--", $boundary);

        $this->subject = "=?iso-2022-jp?B?" . base64_encode(mb_convert_encoding($this->subject, $this->charMail, $this->charCode)) . "?=";
        $result = @mail($this->to, $this->subject, $msg, $this->header);
        
        return $result;
    }/*}}}*/
    
    // ● 添付+HTMLメール送信(携帯用)
    public function htmlAttachMail($fileAt, $fileTy, $msgHtml, $msgText)/*{{{*/
    {
        $this->header = "";
        $this->setHeader();
        $this->header .= "Mime-Version: 1.0\n";
        $this->header .= "Content-Type: multipart/mixed; boundary=XQMvRaoV_0_\n";
        $this->header .= "\n";
        $this->header .= "--XQMvRaoV_0_\n";
        $this->header .= "Content-Type: multipart/related; boundary=XQMvRaoV\n";
        $this->header .= "\n";
        $this->header .= "--XQMvRaoV\n";
        $this->header .= "Content-Type: multipart/alternative; boundary=379I6yr0\n";
        $this->header .= "\n";
        $this->header .= "--379I6yr0\n";
        $this->header .= "Content-Type: text/plain; charset=iso-2022-jp\n";
        $this->header .= "Content-Transfer-Encoding: 7bit\n";
        $this->header .= "\n";
        $this->header .= "\n";
        $this->header .= mb_convert_encoding($msg_text, $this->charMail, $this->charCode);
        $this->header .= "\n";
        $this->header .= "--379I6yr0\n";
        $this->header .= "Content-Type: text/html; charset=iso-2022-jp\n";
        $this->header .= "Content-Transfer-Encoding: quoted-printable\n";
        $this->header .= "\n";
        $this->header .= mb_convert_encoding($msg_html, $this->charMail, $this->charCode);
        $this->header .= "\n";
        $this->header .= "--379I6yr0--\n";
        for ($i = 0; $i < count($fileAt); $i++) {
            $fileName = sprintf("./%s", $fileAt[$i]);
            $fp = fopen($fileName, "r");
            $contents = @fread($fp, filesize($fileName));
            @fclose($fp);
            $fileEncoded = @chunk_split(base64_encode($contents));
            $this->header .= "--XQMvRaoV\n";
            $this->header .= sprintf("Content-ID: <%s>\n", $fileAt[$i]);
            $this->header .= sprintf("Content-Type: %s; name=%s\n", $fileTy[$i], $fileAt[$i]);
            $this->header .= "Content-Transfer-Encoding: base64\n";
            $this->header .= "\n";
            $this->header .= $fileEncoded;
            $this->header .= "\n";
        }
        $this->header .= "--XQMvRaoV--\n";
        $this->header .= "--XQMvRaoV_0_\n";
        $this->header .= "--XQMvRaoV_0_--\n";


        $this->subject = "=?iso-2022-jp?B?" . base64_encode(mb_convert_encoding($this->subject, $this->charMail, $this->charCode)) . "?=";
        $this->message = @mb_convert_encoding($this->message, $this->charMail, $this->charCode);
        return @mail($this->to, $this->subject, $this->message, $this->header);
    }/*}}}*/

    // ● 添付ファイルのセッター
    public function setUpfile($str)/*{{{*/
    {
        $this->upfile = $str;
    }/*}}}*/
    
    // ● 送信者名のセッター
    public function setFromName($str)/*{{{*/
    {
        if ($str !== "") {
            $this->fromName = @mb_convert_kana($str, "K");
            $this->fromName = @mb_convert_encoding($this->fromName, $this->charMail, $this->charCode);
            $this->fromName = @mb_encode_mimeheader($this->fromName);
        } else {
            $this->fromName = "";
        }
    }/*}}}*/
    
    // ● 送信者メールアドレスのセッター
    public function setFromAddr($str)/*{{{*/
    {
        $this->fromAddr = "<" . $str . ">";
    }/*}}}*/
    
    // ● 受信者名のセッター
    public function setToName($str)/*{{{*/
    {
        if ($str !== "") {
            $this->toName = @mb_convert_kana($str, "K");
            $this->toName = @mb_convert_encoding($this->toName, $this->charMail, $this->charCode);
            $this->toName = @mb_encode_mimeheader($this->toName);
        } else {
            $this->toName = "";
        }
    }/*}}}*/
    
    // ● 受信者メールアドレスのセッター
    public function setToAddr($str)/*{{{*/
    {
        $this->toAddr = "<" . $str . ">";
    }/*}}}*/
    
    // ● 返信先メールアドレスのセッター
    public function setReplyTo($str)/*{{{*/
    {
        $this->replyTo = $str;
    }/*}}}*/
    
    // ● リターンメールのアドレスのセッター
    public function setReturnTo($str)/*{{{*/
    {
        $this->returnTo = $str;
    }/*}}}*/
    
    // ● 件名のセッター
    public function setSubject($str)/*{{{*/
    {
        $this->subject = @mb_convert_kana($str, "K");
    }/*}}}*/
    
    // ● 本文のセッター
    public function setMessage($str)/*{{{*/
    {
        $this->message = @mb_convert_kana($str, "K");
    }/*}}}*/
    
    // ● MIMEヘッダのセッター
    public function getMime($extensionName)/*{{{*/
    {
        $arrMime = array();
        $arrMime['htm'] = "text/html";
        $arrMime['html'] = "text/html";
        $arrMime['tex'] = "application/x-latex";
        $arrMime['latex'] = "application/x-latex";
        $arrMime['ltx'] = "application/x-latex";
        $arrMime['pdf'] = "application/pdf";
        $arrMime['ps'] = "application/postscript";
        $arrMime['rtf'] = "application/rtf";
        $arrMime['sgm'] = "text/sgml";
        $arrMime['sgml'] = "text/sgml";
        $arrMime['tab'] = "text/tab-separated-values";
        $arrMime['tsv'] = "text/tab-separated-values";
        $arrMime['txt'] = "text/plain";
        $arrMime['xml'] = "text/xml";
        $arrMime['jar'] = "application/java-archiver";
        $arrMime['cpt'] = "application/mac-compactpro";
        $arrMime['gz'] = "application/gzip";
        $arrMime['hqx'] = "application/mac-binhex40";
        $arrMime['sh'] = "application/x-sh";
        $arrMime['shar'] = "application/x-shar";
        $arrMime['sit'] = "application/x-stuffit";
        $arrMime['tar'] = "application/x-tar";
        $arrMime['z'] = "application/x-compress";
        $arrMime['zip'] = "application/zip";
        $arrMime['ai'] = "application/postscript";
        $arrMime['bmp'] = "image/x-bmp";
        $arrMime['rle'] = "image/x-bmp";
        $arrMime['dib'] = "image/x-bmp";
        $arrMime['cgm'] = "image/cgm";
        $arrMime['dwf'] = "drawing/x-dwf";
        $arrMime['epsf'] = "appilcation/postscript";
        $arrMime['eps'] = "appilcation/postscript";
        $arrMime['ps'] = "appilcation/postscript";
        $arrMime['fif'] = "image/fif";
        $arrMime['fpx'] = "image/fpx";
        $arrMime['gif'] = "image/gif";
        $arrMime['jpg'] = "image/jpeg";
        $arrMime['jpeg'] = "image/jpeg";
        $arrMime['jpe'] = "image/jpeg";
        $arrMime['jfif'] = "image/jpeg";
        $arrMime['jfi'] = "image/jpeg";
        $arrMime['pcd'] = "image/pcd";
        $arrMime['pict'] = "image/pict";
        $arrMime['pct'] = "image/pict";
        $arrMime['png'] = "image/png";
        $arrMime['tga'] = "image/x-targa";
        $arrMime['tpic'] = "image/x-targa";
        $arrMime['vda'] = "image/x-targa";
        $arrMime['vst'] = "image/x-targa";
        $arrMime['tiff'] = "image/tiff";
        $arrMime['tif'] = "image/tiff";
        $arrMime['wrl'] = "model/vrml";
        $arrMime['xbm'] = "image/x-bitmap";
        $arrMime['xpm'] = "image/x-xpixmap";
        $arrMime['aiff'] = "audio/aiff";
        $arrMime['aif'] = "audio/aiff";
        $arrMime['au'] = "audio/basic";
        $arrMime['kar'] = "audio/midi";
        $arrMime['m1a'] = "audio/mpeg";
        $arrMime['m2a'] = "audio/mpeg";
        $arrMime['midi'] = "audio/midi";
        $arrMime['mid'] = "audio/midi";
        $arrMime['smf'] = "audio/midi";
        $arrMime['mp2'] = "audio/mpeg";
        $arrMime['mp3'] = "audio/mpeg";
        $arrMime['mpa'] = "audio/mpeg";
        $arrMime['mpega'] = "audio/mpeg";
        $arrMime['rpm'] = "audio/x-pn-realaudio-plugin";
        $arrMime['snd'] = "audio/basic";
        $arrMime['swa'] = "application/x-director";
        $arrMime['vqf'] = "audio/x-twinvq";
        $arrMime['wav'] = "audio/wav";
        $arrMime['aab'] = "application/x-authorware-bin";
        $arrMime['aam'] = "application/x-authorware-map";
        $arrMime['aas'] = "application/x-authorware-seg";
        $arrMime['asf'] = "video/x-ms-asf";
        $arrMime['avi'] = "vide/x-msvideo";
        $arrMime['dcr'] = "application/x-director";
        $arrMime['dir'] = "application/x-director";
        $arrMime['dxr'] = "application/x-director";
        $arrMime['flc'] = "video/flc";
        $arrMime['fli'] = "video/flc";
        $arrMime['mng'] = "video/mng";
        $arrMime['m1s'] = "vide/mpeg";
        $arrMime['m2s'] = "vide/mpeg";
        $arrMime['m1v'] = "vide/mpeg";
        $arrMime['m2v'] = "vide/mpeg";
        $arrMime['moov'] = "video/quicktime";
        $arrMime['mov'] = "video/quicktime";
        $arrMime['qt'] = "video/quicktime";
        $arrMime['mpeg'] = "vide/mpeg";
        $arrMime['mpg'] = "vide/mpeg";
        $arrMime['mpeg'] = "vide/mpeg";
        $arrMime['mpe'] = "vide/mpeg";
        $arrMime['mpv'] = "vide/mpeg";
        $arrMime['ppt'] = "application/ppt";
        $arrMime['rm'] = "audio/x-pn-realaudio";
        $arrMime['spl'] = "application/futuresplash";
        $arrMime['swf'] = "application/x-shockwave-flash";
        $arrMime['vdo'] = "video/vdo";
        $arrMime['viv'] = "video/vnd.vivo";
        $arrMime['vivo'] = "video/vnd.vivo";
        $arrMime['xdm'] = "application/x-xdma";
        $arrMime['xdma'] = "application/x-xdma";
        $arrMime['cdf'] = "application/x-netcdf";
        $arrMime['class'] = "application/octet-stream";
        $arrMime['exe'] = "application/exe";
        $arrMime['pl'] = "application/x-perl";
        $arrMime['ram'] = "audio/x-pn-realaudio";
        $arrMime['vdb'] = "application/activexdocument";
        $arrMime['vqe'] = "audio/x-twinvq";
        $arrMime['vql'] = "audio/x-twinvq";
        return $arrMime[$extensionName];
    }/*}}}*/

    // ● ヘッダ整形
    public function setHeader()/*{{{*/
    {
        $this->from = $this->fromName . $this->fromAddr;
        $this->to = $this->toName . $this->toAddr;
        
        $this->header .= "From: " . $this->from . "\r\n";
        
        if ($this->replyTo != "") {
            $this->header .= "Reply-To: " . $this->replyTo . "\r\n";
        }
        
        $this->header .= "Return-path: " . $this->returnTo . "\r\n";
    }/*}}}*/
}

