<?php

/**
 * セッションクラス
 * @author: Tomohiro Suzuki <suzuki@freepg.jp>
 */
/* vim: set expandtab sw=4 ts=4 sts=4 fdm=marker: */

class ClassSession
{
    // ● メンバー変数
    ///*{{{*/
    protected $nameSpace = "";
    protected $arr = array();
    ///*}}}*/

    // ● コンストラクタ
    public function __construct($nameSpace)/*{{{*/
    {
        $this->nameSpace = $nameSpace;
        if (is_array($_SESSION[$this->nameSpace])) {
            foreach ($_SESSION[$this->nameSpace] as $key => $value) {
                $this->arr[$key] = $value;
            }
        }
    }/*}}}*/

    // ● オーバーロード（セット）
    protected function __set($name, $value)/*{{{*/
    {
        $_SESSION[$this->nameSpace][$name] = $value;
        $this->arr[$name] = $value;
    }/*}}}*/

    // ● オーバーロード（ゲット）
    protected function & __get($name)/*{{{*/
    {
        if (is_null($name)) {
            return $_SESSION[$this->nameSpace];
        } else {
            return $_SESSION[$this->nameSpace][$name];
        }
    }/*}}}*/

    // ● 初期化
    public function init()/*{{{*/
    {
        $_SESSION[$this->nameSpace] = array();
        $this->arr = array();
    }/*}}}*/

    // ● 全値を取得
    public function getAll()/*{{{*/
    {
        return $this->arr;
    }/*}}}*/
}

