<?php

/**
 * コントローラ（実装例）
 * @author: Tomohiro Suzuki <suzuki@freepg.jp>
 */
/* vim: set expandtab sw=4 ts=4 sts=4 fdm=marker: */

$model = new ClassModelExample();
$session = new ClassSession(SESSION_EXAMPLE);

switch ($_PARAM['page']) {
// 新規作成
case "insert" :
    ///*{{{*/
    switch ($_PARAM['step']) {
    // 確認
    case "confirm" :
        ///*{{{*/
        foreach ($model->arrPost as $key => $value) {
            $session->$key = $value;
        }
        if (($errorMsg = $model->chkEmpty($session)) !== "") {
            $session->errorMsg = sprintf(ERROR_FORMAT, $errorMsg);
            header(sprintf("Location: %s", URL_INSERT));
            exit;
        }
        if (($errorMsg = $model->chkInvalid($session)) !== "") {
            $session->errorMsg = sprintf(ERROR_FORMAT, $errorMsg);
            header(sprintf("Location: %s", URL_INSERT));
            exit;
        }
        $session->errorMsg = "";
        $arrSession = $session->getAll();
        foreach ($arrSession as $key => $value) {
            $smarty->assign($key, $model->h($value));
        }
        $arrPrefecture = mb_split(DELIMITER, PREFECTURE);
        $smarty->assign("prefecture", $arrPrefecture[$session->prefecture]);
        $smarty->assign("urlAction", URL_INSERT_FIN);
        $smarty->assign("msg", MSG_INSERT_CONFIRM);
        $smarty->display("example_confirm.html");
        break;
        ///*}}}*/
    // 完了
    case "fin" :
        ///*{{{*/
        if (($errorMsg = $model->chkEmpty($session)) !== "") {
            $session->errorMsg = sprintf(ERROR_FORMAT, $errorMsg);
            header(sprintf("Location: %s", URL_INSERT));
            exit;
        }
        if (($errorMsg = $model->chkInvalid($session)) !== "") {
            $session->errorMsg = sprintf(ERROR_FORMAT, $errorMsg);
            header(sprintf("Location: %s", URL_INSERT));
            exit;
        }
        $model->insertMember($session);
        $smarty->assign("msg", MSG_INSERT_FIN);
        $smarty->assign("url", URL_EXAMPLE);
        $smarty->display("example_fin.html");
        break;
        ///*}}}*/
    // 入力
    default :
        ///*{{{*/
        $arrSession = $session->getAll();
        foreach ($arrSession as $key => $value) {
            $smarty->assign($key, $value);
        }
        $smarty->assign("prefecture", $model->createListbox("prefecture", PREFECTURE, DELIMITER, $session->prefecture));
        $smarty->assign("urlAction", URL_INSERT_CONFIRM);
        $smarty->assign("urlBack", URL_EXAMPLE);
        $smarty->assign("msg", MSG_INSERT_INPUT);
        $smarty->display("example_input.html");
        break;
        ///*}}}*/
    }
    break;
    ///*}}}*/
// 更新
case "update" :
    ///*{{{*/
    switch ($_PARAM['step']) {
    // 確認
    case "confirm":
        ///*{{{*/
        if (!$model->isMember($_PARAM['no'])) {
            $smarty->assign("errorMsg", ERROR_MEMBER_NOT_FOUND);
            $smarty->display("error.html");
            exit;
        }
        foreach ($model->arrPost as $key => $value) {
            $session->$key = $value;
        }
        if (($errorMsg = $model->chkEmpty($session)) !== "") {
            $session->errorMsg = sprintf(ERROR_FORMAT, $errorMsg);
            header(sprintf("Location: %s", URL_UPDATE . "no/". $_PARAM['no']));
            exit;
        }
        if (($errorMsg = $model->chkInvalid($session)) !== "") {
            $session->errorMsg = sprintf(ERROR_FORMAT, $errorMsg);
            header(sprintf("Location: %s", URL_UPDATE . "no/". $_PARAM['no']));
            exit;
        }
        $session->errorMsg = "";
        $arrSession = $session->getAll();
        foreach ($arrSession as $key => $value) {
            $smarty->assign($key, $model->h($value));
        }
        $arrPrefecture = mb_split(DELIMITER, PREFECTURE);
        $smarty->assign("prefecture", $arrPrefecture[$session->prefecture]);
        $smarty->assign("urlAction", URL_UPDATE_FIN . "no/" . $_PARAM['no']);
        $smarty->assign("msg", MSG_INSERT_CONFIRM);
        $smarty->display("example_confirm.html");
        break;
        ///*}}}*/
    // 完了
    case "fin":
        ///*{{{*/
        if (!$model->isMember($_PARAM['no'])) {
            $smarty->assign("errorMsg", ERROR_MEMBER_NOT_FOUND);
            $smarty->display("error.html");
            exit;
        }
        if (($errorMsg = $model->chkEmpty($session)) !== "") {
            $session->errorMsg = sprintf(ERROR_FORMAT, $errorMsg);
            header(sprintf("Location: %s", URL_UPDATE . "no/". $_PARAM['no']));
            exit;
        }
        if (($errorMsg = $model->chkInvalid($session)) !== "") {
            $session->errorMsg = sprintf(ERROR_FORMAT, $errorMsg);
            header(sprintf("Location: %s", URL_UPDATE . "no/". $_PARAM['no']));
            exit;
        }
        $model->updateMember($session, $_PARAM['no']);
        $smarty->assign("msg", MSG_UPDATE_FIN);
        $smarty->assign("url", URL_EXAMPLE);
        $smarty->display("example_fin.html");
        break;
        ///*}}}*/
    // 入力
    default :
        ///*{{{*/
        if (!$model->isMember($_PARAM['no'])) {
            $smarty->assign("errorMsg", ERROR_MEMBER_NOT_FOUND);
            $smarty->display("error.html");
            exit;
        }
        $arrSession = $session->getAll();
        if (count($arrSession)) {
            foreach ($arrSession as $key => $value) {
                $smarty->assign($key, $value);
            }
            $smarty->assign("prefecture", $model->createListbox("prefecture", PREFECTURE, DELIMITER, $session->prefecture));
        } else {
            $arrMember = $model->getMember($_PARAM['no']);
            foreach ($arrMember as $key => $value) {
                $smarty->assign($key, $value);
            }
            $smarty->assign("prefecture", $model->createListbox("prefecture", PREFECTURE, DELIMITER, $arrMember['prefecture']));
        }
        $smarty->assign("urlAction", URL_UPDATE_CONFIRM . "no/" . $_PARAM['no']);
        $smarty->assign("urlBack", URL_EXAMPLE);
        $smarty->assign("msg", MSG_UPDATE_INPUT);
        $smarty->display("example_input.html");
        break;
        ///*}}}*/
    }
    break;
    ///*}}}*/
// 削除
case "delete" :
    ///*{{{*/
    switch ($_PARAM['step']) {
    // 完了
    case "fin":
        ///*{{{*/
        if (!$model->isMember($_PARAM['no'])) {
            $smarty->assign("errorMsg", ERROR_MEMBER_NOT_FOUND);
            $smarty->display("error.html");
            exit;
        }
        $model->deleteMember($_PARAM['no']);
        $smarty->assign("msg", MSG_DELETE_FIN);
        $smarty->assign("url", URL_EXAMPLE);
        $smarty->display("example_fin.html");
        break;
        ///*}}}*/
    // 確認
    default :
        ///*{{{*/
        if (!$model->isMember($_PARAM['no'])) {
            $smarty->assign("errorMsg", ERROR_MEMBER_NOT_FOUND);
            $smarty->display("error.html");
            exit;
        }
        $arrMember = $model->getMember($_PARAM['no']);
        foreach ($arrMember as $key => $value) {
            $smarty->assign($key, $model->h($value));
        }
        $arr = mb_split(DELIMITER, PREFECTURE);
        $smarty->assign("prefecture", $arr[$arrMember['prefecture']]);
        $smarty->assign("urlAction", URL_DELETE_FIN . "no/" . $_PARAM['no']);
        $smarty->assign("urlBack", URL_EXAMPLE);
        $smarty->assign("msg", MSG_DELETE_CONFIRM);
        $smarty->display("example_confirm.html");
        break;
        ///*}}}*/
    }
    break;
    ///*}}}*/
// TOP（一覧表示）
default :
    ///*{{{*/
    $session->init();
    $arr = array();
    $arrPrefecture = mb_split(DELIMITER, PREFECTURE);
    $arrMember = $model->getMember();
    for ($i = 0; $i < count($arrMember); $i++) {
        $arr[$i]['no'] = $arrMember[$i]['no'];
        $arr[$i]['name'] = $model->h($arrMember[$i]['name']);
        $arr[$i]['age'] = $model->howOld($arrMember[$i]['yyyy'], $arrMember[$i]['mm'], $arrMember[$i]['dd']);
        $arr[$i]['prefecture'] = $arrPrefecture[$arrMember[$i]['prefecture']];
        $arr[$i]['update'] = sprintf("<A href='%s'>更新</A>", URL_UPDATE . "no/" . $arrMember[$i]['no']);
        $arr[$i]['delete'] = sprintf("<A href='%s'>削除</A>", URL_DELETE . "no/" . $arrMember[$i]['no']);
    }
    $smarty->assign("arr", $arr);
    $smarty->assign("urlInsert", URL_INSERT);
    $smarty->display("example_index.html");
    break;
    ///*}}}*/
}

