package org.torikiri.jexpression;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

import org.torikiri.jexpression.expression.BigDecimalValueExpression;

public class JEContext {

	private Map ctx = new HashMap();

	private Integer roundingMode;

	private Integer scale;

	public JEContext() {}

	public JEContext(int roundingMode) {
		this.roundingMode = Integer.valueOf(roundingMode);
	}

	public JEContext(int scale, int roundingMode) {
		this.scale = Integer.valueOf(scale);
		this.roundingMode = Integer.valueOf(roundingMode);
	}

	public JEContext append(String varName, JExpression func) {
		ctx.put(varName, func);
		return this;
	}

	public JEContext append(String varName, String func) {
		return append(varName, JECompiler.compile(func));
	}

	public JEContext append(String varName, BigDecimal value) {
		return append(varName, new BigDecimalValueExpression(value));
	}

	public JEContext append(String varName, int value) {
		return append(varName, new BigDecimal(value));
	}

	public JEContext append(String varName, long value) {
		return append(varName, BigDecimal.valueOf(value));
	}

	public JExpression getFunc(String varName) {
		JExpression result = (JExpression) ctx.get(varName);
		if (result == null) {
			throw new IllegalArgumentException("No such variable. [" + varName + "]");
		}
		return result;
	}

	public JEContext roundingMode(int roundingMode) {
		this.roundingMode = new Integer(roundingMode);
		return this;
	}

	public int getRoundingMode() {
		return roundingMode.intValue();
	}

	public boolean hasRoundingMode() {
		return roundingMode != null;
	}

	public JEContext scale(int scale) {
		this.scale = new Integer(scale);
		return this;
	}

	public int getScale() {
		return scale.intValue();
	}

	public boolean hasScale() {
		return scale != null;
	}
}
