package org.torikiri.jexpression;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;


public class JEUtils {

	private static final Pattern NUMERIC_PATTERN = Pattern.compile("^-?[0-9]+$");

	private static final Pattern STARTS_WITH_NUMERIC_PATTERN = Pattern.compile("^-?[0-9]+");

	private static final List ESCAPE_REGEX_LIST;

	static {
		ESCAPE_REGEX_LIST = Arrays.asList(new String[] {
			"^", "$", "+", "?", "*"
		});
	}

	private JEUtils() {};

	public static boolean isNumeric(String str) {
		return NUMERIC_PATTERN.matcher(str).matches();
	}

	public static int startsWithNumeric(String str) {
		Matcher m = STARTS_WITH_NUMERIC_PATTERN.matcher(str);
		if (m.find()) {
			return m.end();
		}
		return -1;
	}

	public static String escapeRegex(String str) {
		if (ESCAPE_REGEX_LIST.contains(str)) {
			return "\\".concat(str);
		}
		return str;
	}

	public static String[] add(String[] source, String add) {
		return add(source, new String[] {add});
	}

	public static String[] add(String[] source, String[] add) {
		String[] result = new String[source.length + add.length];
		System.arraycopy(source, 0, result, 0, source.length);
		System.arraycopy(add, 0, result, source.length, add.length);
		return result;
	}

	private static int[] add(int[] source, int add) {
		int[] result = new int[source.length + 1];
		System.arraycopy(source, 0, result, 0, source.length);
		result[result.length] = add;
		return result;
	}

	public static int[] indexesOfChar(String str, char c) {
		char[] array = str.toCharArray();
		int result[] = new int[0];
		for (int i=0; i<array.length; i++) {
			if (array[i] == c) {
				result = add(result, i);
			}
		}
		return result;
	}

	public static String toString(Object[] array) {
		return toString(array, "");
	}

	public static String toString(Object[] array, String str) {
		StringBuffer buff = new StringBuffer();
		for (int i=0; i<array.length; i++) {
			if (buff.length() > 0) {
				buff.append(str);
			}
			buff.append(array[i]);
		}
		return buff.toString();
	}

	public static int countOfChar(String str, char c) {
		char[] array = str.toCharArray();
		int result = 0;
		for (int i=0; i<array.length; i++) {
			if (array[i] == c) {
				result++;
			}
		}
		return result;
	}

	public static String[] subArray(String[] array, int startIndex) {
		return subArray(array, startIndex, array.length - startIndex);
	}

	public static String[] subArray(String[] array, int startIndex, int length) {
		String[] result = new String[length];
		System.arraycopy(array, startIndex, result, 0, length);
		return result;
	}
	
}
