/**
 * 
 */
package org.torikiri.jexpression.expression;

import java.math.BigDecimal;

import org.torikiri.jexpression.JEContext;
import org.torikiri.jexpression.JExpression;
import org.torikiri.jexpression.Operation;

public class CompositeExpression implements JExpression {

	private JExpression expr1;

	private JExpression expr2;

	private Operation op;

	public CompositeExpression(JExpression expr1, JExpression expr2, Operation op) {
		this.expr1 = expr1;
		this.expr2 = expr2;
		this.op = op;
	}

	public BigDecimal calculate(JEContext ctx) {
		return op.calculate(expr1.calculate(ctx), expr2.calculate(ctx), ctx);
	}

	public void optimize() {
		Optimizer.Factory.createOptimizer().optimize(this);
	}

	public JExpression getExpr1() {
		return expr1;
	}

	public JExpression getExpr2() {
		return expr2;
	}

	public Operation getOp() {
		return op;
	}
	
	public void setExpr1(JExpression expr) {
		this.expr1 = expr;
	}

	public void setExpr2(JExpression expr) {
		this.expr2 = expr;
	}

	public void setOp(Operation op) {
		this.op = op;
	}

	/**
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		StringBuffer buff = new StringBuffer();

		if (expr1 instanceof CompositeExpression) {
			buff.append("(").append(expr1).append(")");
		} else {
			buff.append(expr1);
		}

		buff.append(" ").append(op).append(" ");

		if (expr2 instanceof CompositeExpression) {
			buff.append("(").append(expr2).append(")");
		} else {
			buff.append(expr2);
		}

		return buff.toString();
	}
}