package org.torikiri.jexpression.expression.optimizer;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

import org.torikiri.jexpression.Operation;
import org.torikiri.jexpression.operation.AddOperation;
import org.torikiri.jexpression.operation.DivideOperation;
import org.torikiri.jexpression.operation.MultiplyOperation;
import org.torikiri.jexpression.operation.PowerOperation;
import org.torikiri.jexpression.operation.SubtractOperation;

public class OptimizePattern {

	public static final OptimizePattern ADD = new OptimizePattern(new AddOperation());

	public static final OptimizePattern SUBTRACT = new OptimizePattern(new SubtractOperation());

	public static final OptimizePattern ADD_SUB = new OptimizePattern(
		new Operation[] {new AddOperation(), new SubtractOperation()});

	public static final OptimizePattern MULTIPLY = new OptimizePattern(new MultiplyOperation());

	public static final OptimizePattern DIVIDE = new OptimizePattern(new DivideOperation());

	public static final OptimizePattern MUL_DIV = new OptimizePattern(
		new Operation[] {new MultiplyOperation(), new DivideOperation()});

	public static final OptimizePattern ADD_SUB_MUL_DIV = new OptimizePattern(
		new Operation[] {new AddOperation(), new SubtractOperation(), new MultiplyOperation(), new DivideOperation()});

	public static final OptimizePattern POWER = new OptimizePattern(new PowerOperation());

	public static final OptimizePattern ALL = new OptimizePattern(
			new Operation[] {new AddOperation(), new SubtractOperation(), new MultiplyOperation(), new DivideOperation(), new PowerOperation()});

	private List operations;

	private OptimizePattern(Operation op) {
		this(new Operation[] {op});
	}

	private OptimizePattern(Operation[] operations) {
		this.operations = Arrays.asList(operations);
	}

	public boolean matches(Operation other) {
		for (Iterator it = operations.iterator(); it.hasNext();) {
			Operation op = (Operation) it.next();
			if (op.equals(other)) {
				return true;
			}
		}
		return false;
	}

	public String toString() {
		return operations.toString();
	}
}
