package org.torikiri.jexpression.operation;

import java.math.BigDecimal;

import org.torikiri.jexpression.JEContext;


public class DivideOperation extends AbstractOperation {

	public DivideOperation() {
		super("/");
	}

	public BigDecimal calculate(BigDecimal val1, BigDecimal val2, JEContext ctx) {
		if (ctx == null) {
			throw new NullPointerException("JEContext is null.");
		}
		if (ctx.hasRoundingMode() && ctx.hasScale()) {
			return val1.divide(val2, ctx.getScale(), ctx.getRoundingMode());
		} else if (ctx.hasRoundingMode()) {
			return val1.divide(val2, ctx.getRoundingMode());
		} else {
			throw new IllegalArgumentException();
		}
	}
}
