enum InputEventType {
	Keyboard,
	Point
}
enum Keytype {
	left,
	right,
	up,
	down,
	enter,
	esc
}
class InputEvent {
	type: InputEventType;
	param: any;

	constructor(type:InputEventType, param?:any) {
		this.type = type;
		this.param = param;
	}
}
class InputKeyboardEvent extends InputEvent {
	key: Keytype;
	constructor(key:Keytype) {
		super(InputEventType.Keyboard, key);
		this.key = this.param;
	}
}
class InputPointEvent extends InputEvent {
	x: number;
	y: number;
	point: CommonOffset;
	entity: E;

	constructor(e:any, entity:E) {
		super(InputEventType.Point, e);
		var entityOffset = entity.offset();
		this.entity = entity;
		this.point = {
			x: e.offsetX,
			y: e.offsetY
		}
		this.x = e.offsetX - entityOffset.x;
		this.y = e.offsetY - entityOffset.y;
	}
}