class FrameGame extends Game {
	_fps:number;

	constructor(width:number, height:number, fps:number) {
		super(width, height);
		this._fps = fps;
		this.targetFps = Math.floor(1000 / this._fps);
		Timeline.prototype.isFrameBased = true;
	}

	main() {
		var fps_stack = new number[];
		var _main = () => {
			var t:number = window.getTime();
			if (this.tick > (t+10000) || (this.tick+10000) < t) {
				//this.tick > (t+10000): 前回更新分が10秒以上未来の時間の場合。多分タイマーバグっとるのでリセット
				//(this.tick+10000) < t: 10秒以上更新されてない。多分タイマーバグっとる。バグっとるよね？
				this.tick = t - 1;
				this.renderTick = t - this.targetFps;
				this.refresh();
			}

			for (var i=0; i<this.timers.length; i++)
				this.timers[i].tryFire(t);

			if ((this.renderTick+this.targetFps) <= t) {
				if (this.fps) {
					fps_stack.shift();
					fps_stack.push(t);
					this.fps.innerHTML = Math.round(60000 / (t-fps_stack[0])).toString();
				}
				if (this.enterFrame)
					this.enterFrame.fire();

				this.update.fire(t - this.tick);
				this.tick = t;
				if (this.render)
					this.render.fire();
				this.renderer.render();
				this.renderTick = t;
			}

			if (! this._exit)
				window.requestAnimationFrame(_main);
		}

		this.tick = window.getTime();
		this.renderTick = this.tick - this.targetFps;
		if (this.fps) {
			for (var i=0; i<60; i++)
				fps_stack.push(0);
		}
		window.requestAnimationFrame(_main);
	}
}