class Rectangle {
	left:number;
	top:number;
	right:number;
	bottom:number;

	constructor(left?:number, top?:number, right?:number, bottom?:number) {
		this.left = left;
		this.top = top;
		this.right = right;
		this.bottom = bottom;
	}

	hitTest(point:CommonOffset) {
		return (this.left <= point.x && this.right >= point.x && this.top <= point.y && this.bottom >= point.y);
	}

	fit(point:CommonOffset) {
		if (point.y<this.top)
			point.y = this.top;
		else if (point.y > this.bottom)
			point.y = this.bottom;

		if (point.x<this.left)
			point.x = this.left;
		else if (point.x > this.right)
			point.x = this.right;
	}
}