///<reference path="all.ts"/>
module jg {
	/**
	 * 入力イベントの基本クラス
	 */
	export class InputEvent {
		/** 入力イベント種別 */
		type: InputEventType;
		/** 入力イベントの動作タイプ */
		action: InputEventAction;
		/** 元イベントデータ */
		param: any;

		/**
		 * コンストラクタ
		 * @param type 入力イベント種別を指定。現状はPointかKeyboardのみ
		 * @param action 入力イベントの動作タイプ。現状はDown, Up, Moveのみ
		 * @param param 元イベントデータ
		 */
		constructor(type:InputEventType, action:InputEventAction, param?:any) {
			this.type = type;
			this.action = action;
			this.param = param;
		}
	}

	/**
	 * キーボードの入力イベントクラス
	 */
	export class InputKeyboardEvent extends InputEvent {
		/** 押されたキー。Keytypeで管理されている値のみ設定可能 */
		key: Keytype;

		/**
		 * コンストラクタ
		 * @param action 入力タイプ
		 * @param key キー
		 * @param e 元イベントデータ
		 */
		constructor(action:InputEventAction, key:Keytype, e:any) {
			super(InputEventType.Keyboard, action, e);
			this.key = key;
		}
	}

	/**
	 * ポインティングデバイスの入力イベント
	 */
	export class InputPointEvent extends InputEvent {
		/** ポインティングされた対象から見てのx座標 */
		x: number;
		/** ポインティングされた対象から見ての y座標 */
		y: number;
		/** Gameから見てのx, y座標 */
		point: CommonOffset;
		/** ポインティングされた対象 */
		entity: E;

		/**
		 * コンストラクタ
		 * @param action 動作タイプ
		 * @param e 元イベントパラメター
		 * @param point ゲームから見ての座標
		 */
		constructor(action:InputEventAction, e:any, point:CommonOffset) {
			super(InputEventType.Point, action, e);
			this.point = point;
		}

		/**
		 * ポインティングされたEntityをセットする
		 * @param entity ポインティングされたEntity
		 */
		set(entity:E) {
			var entityOffset = entity.offset();
			this.entity = entity;
			this.x = this.point.x - entityOffset.x;
			this.y = this.point.y - entityOffset.y;
		}
	}
}