///<reference path="all.ts"/>
module jg {
	/**
	 * レイヤー
	 */
	export class Layer extends E {
		/** レイヤーの描画結果を保持するバッファ */
		canvas: HTMLCanvasElement;
		/** レイヤーの描画コンテキスト */
		context: CanvasRenderingContext2D;

		/**
		 * コンストラクタ
		 * @param scene レイヤーが属するシーン
		 */
		constructor(scene:Scene) {
			super();
			this.entities = [];
			this.x = 0;
			this.y = 0;
			this.scene = scene;
			if (this.scene) {
				this.width = this.scene.game.width;
				this.height = this.scene.game.height;
			}
			this.isUpdated = true;
		}

		/**
		 * このレイヤーがバッファを持つ場合にはtrueを返す
		 */
		hasBuffer() {
			if (this.canvas)
				return true;
			return false;
		}

		/**
		 * このレイヤーにバッファを作成する
		 */
		createBuffer() {
			this.refresh(true);
		}

		/**
		 * レイヤー内のオブジェクトを更新する
		 * @param must trueを指定すると必ずバッファを生成する
		 */
		refresh(must?:boolean) {
			if (must || this.hasBuffer()) {
				this.canvas = window.createCanvas(this.width, this.height);
				this.context = this.canvas.getContext("2d");
				this.updated();
			}
			if (this.entities) {
				for (var i=0; i<this.entities.length; i++) {
					if (this.entities[i]["refresh"])
						this.entities[i]["refresh"]();
				}
			}
		}

		/**
		 * バッファを削除する
		 */
		deleteBuffer() {
			delete this.context;
			delete this.canvas;
		}

		/**
		 * バッファなどを削除する
		 */
		destroy() {
			super.destroy();
			if (this.hasBuffer())
				this.deleteBuffer();
		}
	}
}