///<reference path="all.ts"/>
module jg {
	/**
	 * ピクセルデータを直接編集するクラス。
	 * 現行バージョンでは少し扱いに癖がある
	 */
	export class Pixel extends E {
		/** 生ピクセルデータ */
		imageData: ImageData;

		/**
		 * コンストラクタ
		 * @param width 横幅
		 * @param height 縦幅
		 * @param srcImage 元画像
		 * @param scale srcImageをwidth, heightの指定に基づいて拡大縮小した上でピクセルデータを生成するかどうか
		 */
		constructor(width:number, height:number, srcImage?:any, scale?:boolean) {
			super();
			this.x = 0;
			this.y = 0;
			this.width = width;
			this.height = height;
			var canvas = window.createCanvas(this.width, this.height);
			var context = canvas.getContext("2d");
			if (srcImage) {
				var image = srcImage;
				if (srcImage instanceof E) {
					var sprite = srcImage.createSprite();
					image = sprite.image;
				}
				if (scale)
					context.drawImage(image, 0, 0, width, height);
				else
					context.drawImage(image, 0, 0);
			}
			this.imageData = context.getImageData(0, 0, this.width, this.height);
			this.disableTransform = true;
		}

		/**
		 * 指定した色で全ピクセルをクリアする
		 * @param r 赤。省略時は0
		 * @param g 緑。省略時は0
		 * @param b 青。省略時は0
		 * @param a 透明度。省略時は0
		 */
		clear(r?:number, g?:number, b?:number, a?:number) {
			if (r === undefined)
				r = 0;
			if (g === undefined)
				g = 0;
			if (b === undefined)
				b = 0;
			if (a === undefined)
				a = 0;
			for (var i=0, len=this.imageData.data.length; i<len; i+=4) {
				this.imageData.data[i] = r;
				this.imageData.data[i+1] = g;
				this.imageData.data[i+2] = b;
				this.imageData.data[i+3] = a;
			}
		}

		/**
		 * ピクセルデータをコンテキストに転送する
		 * @param context 対象の描画コンテキスト
		 */
		draw(context:CanvasRenderingContext2D) {
			context.putImageData(
				this.imageData,
				this.x,
				this.y
			);
		}
	}
}