///<reference path="all.ts"/>
module jg {
	/**
	 * リソース構造クラス
	 */
	export class ResourceStructure {
		/** 画像のパス */
		img: string;
		/** サウンドのパス */
		sound:string;
		/** デフォルトのリソース構造 */
		static Default: ResourceStructure = new ResourceStructure("img/", "sound/");
		/** よく使われることを想定しているプレーンな構造 */
		static Plain: ResourceStructure = new ResourceStructure("", "");

		/**
		 * コンストラクタ
		 * @param img 画像のパス
		 * @param sound サウンドのパス
		 */
		constructor(img:string, sound:string) {
			this.img = img;
			this.sound = sound;
		}

		/**
		 * 絶対パスかどうかを判定
		 * @param url 判定するURL
		 */
		isAbsolute(url:string) {
			var white = [".","/"];
			if (white.indexOf(url.charAt(0)) >= 0 || url.match(/^(http:|https:|data:)/))
				return url;
		}

		/**
		 * 構造に則った画像のURLを返す
		 * @param url 画像のパス
		 */
		imageUrl(url:string) {
			if (this.isAbsolute(url))
				return url;
			return this.img + url;
		}

		/**
		 * 構造に則ったサウンドのURLを返す
		 * @param url サウンドのパス
		 */
		soundUrl(url:string) {
			if (this.isAbsolute(url))
				return url;
			return this.sound + url;
		}
	}
}