/*
 * Decompiled with CFR 0.152.
 */
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class CSSBoxPositionDialog
extends HTMLDialog {
    private JCheckBox topBtn = new JCheckBox("top");
    private JCheckBox rightBtn = new JCheckBox("right");
    private JCheckBox bottomBtn = new JCheckBox("bottom");
    private JCheckBox leftBtn = new JCheckBox("left");
    private LengthPanel topPane;
    private LengthPanel bottomPane;
    private LengthPanel rightPane;
    private LengthPanel leftPane;

    public CSSBoxPositionDialog(TextView view) {
        super(view);
        this.setDialog(view, "\u4f4d\u7f6e\u6307\u5b9a", 100, 100);
    }

    protected JPanel createHTMLDocumentPanel() {
        this.topPane = new LengthPanel();
        this.rightPane = new LengthPanel();
        this.bottomPane = new LengthPanel();
        this.leftPane = new LengthPanel();
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints gc = new GridBagConstraints();
        JPanel pane = new JPanel(layout);
        gc.fill = 2;
        gc.insets = new Insets(5, 5, 5, 5);
        gc.gridwidth = 1;
        gc.gridheight = 1;
        this.gridLayoutComponent(pane, layout, gc, this.topBtn, 0, 0, true);
        this.gridLayoutComponent(pane, layout, gc, this.topPane.getPanel(), 1, 0, true);
        this.gridLayoutComponent(pane, layout, gc, this.rightBtn, 0, 1, true);
        this.gridLayoutComponent(pane, layout, gc, this.rightPane.getPanel(), 1, 1, true);
        this.gridLayoutComponent(pane, layout, gc, this.bottomBtn, 0, 2, true);
        this.gridLayoutComponent(pane, layout, gc, this.bottomPane.getPanel(), 1, 2, true);
        this.gridLayoutComponent(pane, layout, gc, this.leftBtn, 0, 3, true);
        this.gridLayoutComponent(pane, layout, gc, this.leftPane.getPanel(), 1, 3, true);
        this.topBtn.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (1 == e.getStateChange()) {
                    CSSBoxPositionDialog.this.topPane.setPanelOn();
                } else {
                    CSSBoxPositionDialog.this.topPane.setPanelOff();
                }
            }
        });
        this.rightBtn.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (1 == e.getStateChange()) {
                    CSSBoxPositionDialog.this.rightPane.setPanelOn();
                } else {
                    CSSBoxPositionDialog.this.rightPane.setPanelOff();
                }
            }
        });
        this.bottomBtn.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (1 == e.getStateChange()) {
                    CSSBoxPositionDialog.this.bottomPane.setPanelOn();
                } else {
                    CSSBoxPositionDialog.this.bottomPane.setPanelOff();
                }
            }
        });
        this.leftBtn.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (1 == e.getStateChange()) {
                    CSSBoxPositionDialog.this.leftPane.setPanelOn();
                } else {
                    CSSBoxPositionDialog.this.leftPane.setPanelOff();
                }
            }
        });
        return pane;
    }

    public String getString() {
        int i;
        StringBuffer buff = new StringBuffer();
        if (this.topBtn.isSelected()) {
            for (i = 0; i < JHime.CSS_TAB_COUNT; ++i) {
                buff.append("\t");
            }
            buff.append("top: ");
            if (this.topPane.isLengthBtn()) {
                buff.append(this.topPane.getLength());
            } else if (this.topPane.isAutoBtn()) {
                buff.append("auto");
            } else {
                buff.append("inherit");
            }
            buff.append(";\n");
        }
        if (this.rightBtn.isSelected()) {
            for (i = 0; i < JHime.CSS_TAB_COUNT; ++i) {
                buff.append("\t");
            }
            buff.append("right: ");
            if (this.rightPane.isLengthBtn()) {
                buff.append(this.rightPane.getLength());
            } else if (this.rightPane.isAutoBtn()) {
                buff.append("auto");
            } else {
                buff.append("inherit");
            }
            buff.append(";\n");
        }
        if (this.bottomBtn.isSelected()) {
            for (i = 0; i < JHime.CSS_TAB_COUNT; ++i) {
                buff.append("\t");
            }
            buff.append("bottom: ");
            if (this.bottomPane.isLengthBtn()) {
                buff.append(this.bottomPane.getLength());
            } else if (this.bottomPane.isAutoBtn()) {
                buff.append("auto");
            } else {
                buff.append("inherit");
            }
            buff.append(";\n");
        }
        if (this.leftBtn.isSelected()) {
            for (i = 0; i < JHime.CSS_TAB_COUNT; ++i) {
                buff.append("\t");
            }
            buff.append("left: ");
            if (this.leftPane.isLengthBtn()) {
                buff.append(this.leftPane.getLength());
            } else if (this.leftPane.isAutoBtn()) {
                buff.append("auto");
            } else {
                buff.append("inherit");
            }
            buff.append(";\n");
        }
        return buff.toString();
    }

    class LengthPanel {
        private JRadioButton lengthBtn = new JRadioButton("\u9577\u3055\u30fb%\u5024", true);
        private JRadioButton autoBtn = new JRadioButton("auto");
        private JRadioButton inheritBtn = new JRadioButton("inherit");
        private JTextField lengthField = new JTextField(10);
        private String[] length_str = new String[]{"%", "em", "ex", "px", "in", "cm", "mm", "pt", "pc"};
        private JComboBox lengthBox = new JComboBox<String>(this.length_str);

        LengthPanel() {
        }

        JPanel getPanel() {
            ButtonGroup btnGroup = new ButtonGroup();
            btnGroup.add(this.lengthBtn);
            btnGroup.add(this.autoBtn);
            btnGroup.add(this.inheritBtn);
            GridBagLayout layout = new GridBagLayout();
            GridBagConstraints gc = new GridBagConstraints();
            JPanel pane = new JPanel(layout);
            gc.fill = 2;
            gc.insets = new Insets(5, 5, 5, 5);
            gc.gridwidth = 1;
            gc.gridheight = 1;
            CSSBoxPositionDialog.this.gridLayoutComponent(pane, layout, gc, this.lengthBtn, 0, 1, false);
            CSSBoxPositionDialog.this.gridLayoutComponent(pane, layout, gc, this.lengthField, 1, 1, false);
            CSSBoxPositionDialog.this.gridLayoutComponent(pane, layout, gc, this.lengthBox, 2, 1, false);
            CSSBoxPositionDialog.this.gridLayoutComponent(pane, layout, gc, this.autoBtn, 3, 1, false);
            CSSBoxPositionDialog.this.gridLayoutComponent(pane, layout, gc, this.inheritBtn, 4, 1, false);
            this.lengthBtn.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    CSSBoxPositionDialog.this.enabledSetting(e, LengthPanel.this.lengthBox);
                    CSSBoxPositionDialog.this.enabledSetting(e, LengthPanel.this.lengthField);
                }
            });
            return pane;
        }

        void setPanelOn() {
            this.lengthBtn.setEnabled(true);
            if (this.lengthBtn.isSelected()) {
                this.lengthField.setEnabled(true);
                this.lengthBox.setEnabled(true);
            }
            this.autoBtn.setEnabled(true);
            this.inheritBtn.setEnabled(true);
        }

        void setPanelOff() {
            this.lengthBtn.setEnabled(false);
            this.lengthField.setEnabled(false);
            this.lengthBox.setEnabled(false);
            this.autoBtn.setEnabled(false);
            this.inheritBtn.setEnabled(false);
        }

        boolean isLengthBtn() {
            return this.lengthBtn.isSelected();
        }

        boolean isAutoBtn() {
            return this.autoBtn.isSelected();
        }

        boolean isInheritBtn() {
            return this.inheritBtn.isSelected();
        }

        String getLength() {
            StringBuffer buff = new StringBuffer();
            buff.append(this.lengthField.getText());
            buff.append(this.lengthBox.getSelectedItem());
            return buff.toString();
        }
    }
}

