/*
 * Decompiled with CFR 0.152.
 */
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class CSSWidthDialog
extends HTMLDialog {
    private JRadioButton lengthBtn = new JRadioButton("\u9577\u3055\u30fb%\u5024", true);
    private JRadioButton autoBtn = new JRadioButton("auto");
    private JRadioButton inheritBtn = new JRadioButton("inherit");
    private JTextField lengthField = new JTextField(10);
    private String[] length_str = new String[]{"%", "em", "ex", "px", "in", "cm", "mm", "pt", "pc"};
    private JComboBox lengthBox = new JComboBox<String>(this.length_str);
    private boolean widthFlag;

    public CSSWidthDialog(TextView view, boolean flag) {
        super(view);
        this.widthFlag = flag;
        String title = this.widthFlag ? "width\u30d7\u30ed\u30d1\u30c6\u30a3" : "height\u30d7\u30ed\u30d1\u30c6\u30a3";
        this.setDialog(view, title, 100, 100);
    }

    protected JPanel createHTMLDocumentPanel() {
        ButtonGroup btnGroup = new ButtonGroup();
        btnGroup.add(this.lengthBtn);
        btnGroup.add(this.autoBtn);
        btnGroup.add(this.inheritBtn);
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints gc = new GridBagConstraints();
        JPanel pane = new JPanel(layout);
        gc.fill = 2;
        gc.insets = new Insets(5, 5, 5, 5);
        gc.gridwidth = 1;
        gc.gridheight = 1;
        this.gridLayoutComponent(pane, layout, gc, this.lengthBtn, 0, 0, true);
        this.gridLayoutComponent(pane, layout, gc, this.lengthField, 1, 0, true);
        this.gridLayoutComponent(pane, layout, gc, this.lengthBox, 2, 0, true);
        this.gridLayoutComponent(pane, layout, gc, this.autoBtn, 0, 1, true);
        this.gridLayoutComponent(pane, layout, gc, this.inheritBtn, 0, 2, true);
        this.lengthBtn.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                CSSWidthDialog.this.enabledSetting(e, CSSWidthDialog.this.lengthBox);
                CSSWidthDialog.this.enabledSetting(e, CSSWidthDialog.this.lengthField);
            }
        });
        return pane;
    }

    public String getString() {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < JHime.CSS_TAB_COUNT; ++i) {
            buff.append("\t");
        }
        if (this.widthFlag) {
            buff.append("width: ");
        } else {
            buff.append("height: ");
        }
        if (this.lengthBtn.isSelected()) {
            buff.append(this.lengthField.getText());
            buff.append(this.lengthBox.getSelectedItem());
        } else if (this.autoBtn.isSelected()) {
            buff.append("auto");
        } else {
            buff.append("inherit");
        }
        buff.append(";\n");
        return buff.toString();
    }
}

