/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.io.StringReader;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class InfoDialog
extends JDialog
implements WindowListener {
    private static final int WARNING_ERROR = 1;
    private static final int STANDARD_ERROR = 2;
    private static final int FATAL_ERROR = 4;
    private static final int CONFIGURATION_ERROR = 8;
    private static final int IO_ERROR = 16;
    private TextView view;
    private JTextArea resultArea = new JTextArea();
    private int errorFlag;

    public InfoDialog(TextView view) {
        super(view, null, false);
        this.view = view;
    }

    public void setDialog(String title, int width, int height) {
        this.setTitle(title);
        this.resultArea.setEditable(false);
        this.resultArea.setLineWrap(true);
        JScrollPane pane = new JScrollPane(this.resultArea);
        this.getContentPane().add((Component)pane, "Center");
        JButton btn1 = new JButton("\u9589\u3058\u308b");
        btn1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                InfoDialog.this.dispose();
            }
        });
        JPanel btnPane = new JPanel();
        btnPane.add(btn1);
        this.getContentPane().add((Component)btnPane, "South");
        this.setDefaultCloseOperation(2);
        int x = this.view.getLocationOnScreen().x;
        int y = this.view.getLocationOnScreen().y;
        x = x + this.view.getSize().width / 2 - width / 2;
        if (x < 0) {
            x = this.view.getLocationOnScreen().x;
        }
        this.setBounds(x, y, width, height);
        this.setVisible(true);
    }

    public void xmlValidation(String str, boolean valid) {
        this.errorFlag = 0;
        if (valid) {
            this.resultArea.setText("XML \u59a5\u5f53\u6027\u691c\u8a3c \u958b\u59cb...\n\n");
        } else {
            this.resultArea.setText("XML \u6574\u5f62\u5f0f\u691c\u8a3c \u958b\u59cb...\n\n");
        }
        try {
            int dtdEnd;
            StringBuffer buff;
            int dtdStart;
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(valid);
            factory.setValidating(valid);
            XMLReader xml = factory.newSAXParser().getXMLReader();
            xml.setFeature("http://xml.org/sax/features/validation", valid);
            xml.setErrorHandler(new XMLHandler());
            if (!valid && (dtdStart = (buff = new StringBuffer(str)).indexOf("<!DOCTYPE")) > 0 && (dtdEnd = buff.indexOf(">", dtdStart)) > dtdStart) {
                buff.insert(dtdEnd, " --");
                buff.insert(dtdStart + 2, "-- ");
                str = buff.toString();
            }
            StringReader sb = new StringReader(str);
            InputSource is = new InputSource(sb);
            xml.parse(is);
        }
        catch (FactoryConfigurationError e) {
        }
        catch (ParserConfigurationException e) {
            this.errorFlag |= 8;
            this.resultArea.append("\u30d1\u30fc\u30b5\u30fc\u30a8\u30e9\u30fc\n" + e.getMessage() + "\n");
        }
        catch (IOException e) {
            this.errorFlag |= 0x10;
            this.resultArea.append("\u30a2\u30af\u30bb\u30b9\u30a8\u30e9\u30fc\n" + e.getMessage() + "\n");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.errorFlag == 0) {
            this.resultArea.append("\u30a8\u30e9\u30fc\u306f\u3042\u308a\u307e\u305b\u3093\u3067\u3057\u305f\u3002\n\u691c\u8a3c\u7d42\u4e86\n");
        } else if ((this.errorFlag & 8) != 0 || (this.errorFlag & 0x10) != 0 || (this.errorFlag & 4) != 0) {
            this.resultArea.append("\n\u691c\u8a3c\u3092\u4e2d\u6b62\u3057\u307e\u3057\u305f\u3002\n");
        } else {
            this.resultArea.append("\n\u691c\u8a3c\u7d42\u4e86\n");
        }
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    class XMLHandler
    extends DefaultHandler {
        XMLHandler() {
        }

        public void error(SAXParseException e) {
            InfoDialog.this.errorFlag |= 2;
            InfoDialog.this.resultArea.append("\u30a8\u30e9\u30fc: (line " + e.getLineNumber() + ")\n");
            InfoDialog.this.resultArea.append(e.getMessage() + "\n");
        }

        public void fatalError(SAXParseException e) {
            InfoDialog.this.errorFlag |= 4;
            InfoDialog.this.resultArea.append("\u81f4\u547d\u7684\u30a8\u30e9\u30fc: (line " + e.getLineNumber() + ")\n");
            InfoDialog.this.resultArea.append(e.getMessage() + "\n");
        }

        public void warning(SAXParseException e) {
            InfoDialog.this.errorFlag |= 1;
            InfoDialog.this.resultArea.append("\u8b66\u544a: (line " + e.getLineNumber() + ")\n");
            InfoDialog.this.resultArea.append(e.getMessage() + "\n");
        }
    }
}

