//
//  CSSAtCharsetDialog.java
//  JHime
//
//  Created by HIROTAKA_YAMASHITA on 08/04/24.
//  Copyright 2008 HIROTAKA_YAMASHITA. All rights reserved.
//

import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CSSAtCharsetDialog extends HTMLDialog {
//================================================================================
//	メンバ変数 (private)
//================================================================================
	private JLabel encodingLabel	= new JLabel("エンコーディング", JLabel.RIGHT);

	private String[] encoding_str	= {"UTF-8", "UTF-16", "Shift_JIS", "EUC-JP", "ISO-2022-JP"};
	private JComboBox encodingBox	= new JComboBox(encoding_str);

//================================================================================
//	コンストラクタ
//================================================================================
	public CSSAtCharsetDialog (TextView view) {
		super(view);
		setDialog(view, "@charset設定", 100, 100);
	}

//================================================================================
//	protectedメソッド
//================================================================================
	//--------------------------------------------------------------------------------
	//	ダイアログパネル生成
	//--------------------------------------------------------------------------------
	protected JPanel createHTMLDocumentPanel() {
		GridBagLayout layout = new GridBagLayout();
		GridBagConstraints gc = new GridBagConstraints();
		JPanel pane = new JPanel(layout);

		gc.fill = GridBagConstraints.HORIZONTAL;
		gc.insets = new Insets(5,5,5,5);
		gc.gridwidth = 1;
		gc.gridheight = 1;

		gridLayoutComponent(pane, layout, gc, encodingLabel, 0, 0, true);
		gridLayoutComponent(pane, layout, gc, encodingBox,	 1, 0, true);

		return pane;
	}

//================================================================================
//	publicメソッド
//================================================================================
	//--------------------------------------------------------------------------------
	//	結果文字列取得
	//--------------------------------------------------------------------------------
	public String getString() {
		StringBuffer buff = new StringBuffer();

		buff.append("@charset \"" + (String)encodingBox.getSelectedItem() + "\";\n");

		return buff.toString();
	}
}