//
//  CSSBoxPositionDialog.java
//  JHime
//
//  Created by HIROTAKA YAMASHITA on 08/04/26.
//  Copyright 2008 HIROTAKA YAMASHITA. All rights reserved.
//

import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.event.ItemListener;
import java.awt.event.ItemEvent;

import javax.swing.ButtonGroup;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

import javax.swing.border.LineBorder;

public class CSSBoxPositionDialog extends HTMLDialog {
//================================================================================
//	内部クラス
//================================================================================
	//--------------------------------------------------------------------------------
	//	lengthパネル生成
	//--------------------------------------------------------------------------------
	class LengthPanel {
		//メンバ変数(private)
		private JRadioButton lengthBtn	= new JRadioButton("長さ・%値", true);
		private JRadioButton autoBtn	= new JRadioButton("auto");
		private JRadioButton inheritBtn	= new JRadioButton("inherit");

		private JTextField lengthField	= new JTextField(10);
		private String[] length_str = {
			"%", "em", "ex", "px", "in", "cm", "mm", "pt", "pc"
		};
		private JComboBox lengthBox		= new JComboBox(length_str);

		//パネル生成
		JPanel getPanel() {
			ButtonGroup btnGroup = new ButtonGroup();
			btnGroup.add(lengthBtn);
			btnGroup.add(autoBtn);
			btnGroup.add(inheritBtn);

			GridBagLayout layout = new GridBagLayout();
			GridBagConstraints gc = new GridBagConstraints();
			JPanel pane = new JPanel(layout);

			gc.fill = GridBagConstraints.HORIZONTAL;
			gc.insets = new Insets(5,5,5,5);
			gc.gridwidth = 1;
			gc.gridheight = 1;

			gridLayoutComponent(pane, layout, gc, lengthBtn,	0, 1, false);
			gridLayoutComponent(pane, layout, gc, lengthField,	1, 1, false);
			gridLayoutComponent(pane, layout, gc, lengthBox,	2, 1, false);
			gridLayoutComponent(pane, layout, gc, autoBtn,		3, 1, false);
			gridLayoutComponent(pane, layout, gc, inheritBtn,	4, 1, false);

			lengthBtn.addItemListener(new ItemListener(){
				public void itemStateChanged(ItemEvent e) {
					enabledSetting(e, lengthBox);
					enabledSetting(e, lengthField);
				}
			});

			return pane;
		}

		//パネル有効
		void setPanelOn() {
			lengthBtn.setEnabled(true);
			if (lengthBtn.isSelected()) {
				lengthField.setEnabled(true);
				lengthBox.setEnabled(true);
			}
			autoBtn.setEnabled(true);
			inheritBtn.setEnabled(true);
		}

		//パネル無効
		void setPanelOff() {
			lengthBtn.setEnabled(false);
			lengthField.setEnabled(false);
			lengthBox.setEnabled(false);
			autoBtn.setEnabled(false);
			inheritBtn.setEnabled(false);
		}

		//length選択状態取得
		boolean isLengthBtn() {
			return lengthBtn.isSelected();
		}

		//auto選択状態取得
		boolean isAutoBtn() {
			return autoBtn.isSelected();
		}

		//inherit選択状態取得
		boolean isInheritBtn() {
			return inheritBtn.isSelected();
		}

		//結果文字列取得
		String getLength() {
			StringBuffer buff = new StringBuffer();

			buff.append(lengthField.getText());
			buff.append(lengthBox.getSelectedItem());

			return buff.toString();
		}
	}


//================================================================================
//	メンバ変数 (private)
//================================================================================
	private JCheckBox topBtn = new JCheckBox("top");
	private JCheckBox rightBtn = new JCheckBox("right");
	private JCheckBox bottomBtn = new JCheckBox("bottom");
	private JCheckBox leftBtn = new JCheckBox("left");

	private LengthPanel topPane, bottomPane, rightPane, leftPane;

//================================================================================
//	コンストラクタ
//================================================================================
	public CSSBoxPositionDialog (TextView view) {
		super(view);
		setDialog(view, "位置指定", 100, 100);
	}

//================================================================================
//	protectedメソッド
//================================================================================
	//--------------------------------------------------------------------------------
	//	ダイアログパネル生成
	//--------------------------------------------------------------------------------
	protected JPanel createHTMLDocumentPanel() {
		topPane = new LengthPanel();
		rightPane = new LengthPanel();
		bottomPane = new LengthPanel();
		leftPane = new LengthPanel();

		GridBagLayout layout = new GridBagLayout();
		GridBagConstraints gc = new GridBagConstraints();
		JPanel pane = new JPanel(layout);

		gc.fill = GridBagConstraints.HORIZONTAL;
		gc.insets = new Insets(5,5,5,5);
		gc.gridwidth = 1;
		gc.gridheight = 1;

		gridLayoutComponent(pane, layout, gc, topBtn,					0, 0, true);
		gridLayoutComponent(pane, layout, gc, topPane.getPanel(),		1, 0, true);
		gridLayoutComponent(pane, layout, gc, rightBtn,					0, 1, true);
		gridLayoutComponent(pane, layout, gc, rightPane.getPanel(),		1, 1, true);
		gridLayoutComponent(pane, layout, gc, bottomBtn,				0, 2, true);
		gridLayoutComponent(pane, layout, gc, bottomPane.getPanel(),	1, 2, true);
		gridLayoutComponent(pane, layout, gc, leftBtn,					0, 3, true);
		gridLayoutComponent(pane, layout, gc, leftPane.getPanel(),		1, 3, true);

		topBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				if (ItemEvent.SELECTED == e.getStateChange()) {
					topPane.setPanelOn();
				} else {
					topPane.setPanelOff();
				}
			}
		});
		rightBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				if (ItemEvent.SELECTED == e.getStateChange()) {
					rightPane.setPanelOn();
				} else {
					rightPane.setPanelOff();
				}
			}
		});
		bottomBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				if (ItemEvent.SELECTED == e.getStateChange()) {
					bottomPane.setPanelOn();
				} else {
					bottomPane.setPanelOff();
				}
			}
		});
		leftBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				if (ItemEvent.SELECTED == e.getStateChange()) {
					leftPane.setPanelOn();
				} else {
					leftPane.setPanelOff();
				}
			}
		});

		return pane;
	}

//================================================================================
//	publicメソッド
//================================================================================
	//--------------------------------------------------------------------------------
	//	結果文字列取得
	//--------------------------------------------------------------------------------
	public String getString() {
		StringBuffer buff = new StringBuffer();

		if (topBtn.isSelected()) {
			for (int i = 0; i < JHime.CSS_TAB_COUNT; i++) {
				buff.append("\t");
			}
			buff.append("top: ");
			if (topPane.isLengthBtn()) {
				buff.append(topPane.getLength());
			} else if (topPane.isAutoBtn()) {
				buff.append("auto");
			} else {
				buff.append("inherit");
			}
			buff.append(";\n");
		}
		if (rightBtn.isSelected()) {
			for (int i = 0; i < JHime.CSS_TAB_COUNT; i++) {
				buff.append("\t");
			}
			buff.append("right: ");
			if (rightPane.isLengthBtn()) {
				buff.append(rightPane.getLength());
			} else if (rightPane.isAutoBtn()) {
				buff.append("auto");
			} else {
				buff.append("inherit");
			}
			buff.append(";\n");
		}
		if (bottomBtn.isSelected()) {
			for (int i = 0; i < JHime.CSS_TAB_COUNT; i++) {
				buff.append("\t");
			}
			buff.append("bottom: ");
			if (bottomPane.isLengthBtn()) {
				buff.append(bottomPane.getLength());
			} else if (bottomPane.isAutoBtn()) {
				buff.append("auto");
			} else {
				buff.append("inherit");
			}
			buff.append(";\n");
		}
		if (leftBtn.isSelected()) {
			for (int i = 0; i < JHime.CSS_TAB_COUNT; i++) {
				buff.append("\t");
			}
			buff.append("left: ");
			if (leftPane.isLengthBtn()) {
				buff.append(leftPane.getLength());
			} else if (leftPane.isAutoBtn()) {
				buff.append("auto");
			} else {
				buff.append("inherit");
			}
			buff.append(";\n");
		}

		return buff.toString();
	}
}