//
//  CSSMarginDialog.java
//  JHime
//
//  Created by 山下 弘隆 on 08/04/25.
//  Copyright 2008 __MyCompanyName__. All rights reserved.
//

import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.event.ItemListener;
import java.awt.event.ItemEvent;

import javax.swing.ButtonGroup;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

import javax.swing.border.LineBorder;

public class CSSMarginDialog extends HTMLDialog {

	class MarginLength {
		private JRadioButton lengthBtn  = new JRadioButton("長さ・%値", true);
		private JRadioButton autoBtn	= new JRadioButton("auto");
		private JRadioButton inheritBtn	= new JRadioButton("inherit");

		private JTextField lengthField = new JTextField(10);
		private String[] length_str = {
			"%", "em", "ex", "px", "in", "cm", "mm", "pt", "pc"
		};
		private JComboBox lengthBox		= new JComboBox(length_str);

		JPanel getLengthPanel() {
			ButtonGroup btnGroup = new ButtonGroup();
			btnGroup.add(lengthBtn);
			btnGroup.add(autoBtn);
			btnGroup.add(inheritBtn);

			GridBagLayout layout = new GridBagLayout();
			GridBagConstraints gc = new GridBagConstraints();
			JPanel pane = new JPanel(layout);

			gc.fill = GridBagConstraints.HORIZONTAL;
			gc.insets = new Insets(5,5,5,5);
			gc.gridwidth = 1;
			gc.gridheight = 1;

			gridLayoutComponent(pane, layout, gc, lengthBtn,	0, 0, true);
			gridLayoutComponent(pane, layout, gc, lengthField,	1, 0, true);
			gridLayoutComponent(pane, layout, gc, lengthBox,	2, 0, true);
			gridLayoutComponent(pane, layout, gc, autoBtn,		3, 0, true);
			gridLayoutComponent(pane, layout, gc, inheritBtn,	4, 0, true);

			lengthBtn.addItemListener(new ItemListener(){
				public void itemStateChanged(ItemEvent e) {
					enabledSetting(e, lengthBox);
					enabledSetting(e, lengthField);
				}
			});

			return pane;
		}

		boolean isLengthButton() {
			return lengthBtn.isSelected();
		}
		boolean isAutoButton() {
			return autoBtn.isSelected();
		}
		boolean isInheritButton() {
			return inheritBtn.isSelected();
		}
		String getLengthField() {
			return lengthField.getText();
		}
		String getLengthBox() {
			return (String)lengthBox.getSelectedItem();
		}
		void setAllEnabled(boolean flag) {
			lengthBtn.setEnabled(flag);
			lengthField.setEnabled(flag);
			lengthBox.setEnabled(flag);
			autoBtn.setEnabled(flag);
			inheritBtn.setEnabled(flag);
		}
		void setButtonEnabled(boolean flag) {
			lengthBtn.setEnabled(flag);
			autoBtn.setEnabled(flag);
			inheritBtn.setEnabled(flag);
		}
		void setFieldEnabled(boolean flag) {
			lengthField.setEnabled(flag);
			lengthBox.setEnabled(flag);
		}
	}


	private JCheckBox marginTopBtn = new JCheckBox("margin-top");
	private JCheckBox marginRightBtn = new JCheckBox("margin-right");
	private JCheckBox marginBottomBtn = new JCheckBox("margin-bottom");
	private JCheckBox marginLeftBtn = new JCheckBox("margin-left");

	private MarginLength marginTop    = new MarginLength();
	private MarginLength marginBottom = new MarginLength();
	private MarginLength marginRight  = new MarginLength();
	private MarginLength marginLeft	  = new MarginLength();


	private JCheckBox fontFamilyBtn = new JCheckBox("font-family");
	private JCheckBox fontStyleBtn = new JCheckBox("font-style");
	private JCheckBox fontWeightBtn = new JCheckBox("font-weight");
	private JCheckBox fontSizeBtn = new JCheckBox("font-size");

	private JCheckBox fontFamilyBoxBtn1 = new JCheckBox();
	private JCheckBox fontFamilyBoxBtn2 = new JCheckBox();
	private String[] fontfamily_str = {
		"serif", "sans-serif", "cursive", "fantasy", "monospace", "inherit"
	};
	private JTextField fontFamilyField1 = new JTextField(10);
	private JTextField fontFamilyField2 = new JTextField(10);
	private JComboBox fontFamilyBox = new JComboBox(fontfamily_str);

	private String[] fontstyle_str = {
		"normal", "italic", "oblique", "inherit"
	};
	private JComboBox fontStyleBox = new JComboBox(fontstyle_str);

	private String[] fontweight_str = {
		"normal", "bold", "bolder", "lighter", "100", "200", "300", "400",
		"500", "600", "700", "800", "900", "inherit"
	};
	private JComboBox fontWeightBox = new JComboBox(fontweight_str);

	private JRadioButton fontSizeKeywordBtn	  = new JRadioButton("キーワード", true);
	private JRadioButton fontSizeLengthBtn	  = new JRadioButton("長さ・%値");
	private String[] fontsize_str = {
		"xx-small", "x-small", "small", "medium", "large", "x-large", "xx-large",
		"larger", "smaller", "inherit"
	};
	private JComboBox fontSizeKeywordBox = new JComboBox(fontsize_str);
	private JTextField fontSizeLengthField = new JTextField(10);
	private String[] length_str = {
		"%", "em", "ex", "px", "in", "cm", "mm", "pt", "pc"
	};
	private JComboBox fontSizeLengthBox		= new JComboBox(length_str);

	private boolean setFlag;

	public CSSMarginDialog (TextView view, boolean flag) {
		super(view);

		String title;
		if (flag) {
			title = "マージン一括設定";
		} else {
			title = "マージン個別設定";
		}
		setDialog(view, title, 100, 100);
		setFlag = flag;
	}

	protected JPanel createHTMLDocumentPanel() {
		GridBagLayout layout = new GridBagLayout();
		GridBagConstraints gc = new GridBagConstraints();
		JPanel pane = new JPanel(layout);

		gc.fill = GridBagConstraints.HORIZONTAL;
		gc.insets = new Insets(10,5,10,5);
		gc.gridwidth = 1;
		gc.gridheight = 1;

		gridLayoutComponent(pane, layout, gc, marginTopBtn,						0, 0, true);
		gridLayoutComponent(pane, layout, gc, marginTop.getLengthPanel(),		1, 0, true);
		gridLayoutComponent(pane, layout, gc, marginRightBtn,					0, 1, true);
		gridLayoutComponent(pane, layout, gc, marginRight.getLengthPanel(),		1, 1, true);
		gridLayoutComponent(pane, layout, gc, marginBottomBtn,					0, 2, true);
		gridLayoutComponent(pane, layout, gc, marginBottom.getLengthPanel(),	1, 2, true);
		gridLayoutComponent(pane, layout, gc, marginLeftBtn,					0, 3, true);
		gridLayoutComponent(pane, layout, gc, marginLeft.getLengthPanel(),		1, 3, true);

		marginTop.setAllEnabled(false);
		marginRight.setAllEnabled(false);
		marginBottom.setAllEnabled(false);
		marginLeft.setAllEnabled(false);

		marginTopBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				if (ItemEvent.SELECTED != e.getStateChange()) {
					marginTop.setAllEnabled(false);
				} else {
					marginTop.setButtonEnabled(true);
					if (marginTop.isLengthButton()) {
						marginTop.setFieldEnabled(true);
					}
				}
			}
		});
		marginRightBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				if (ItemEvent.SELECTED != e.getStateChange()) {
					marginRight.setAllEnabled(false);
				} else {
					marginRight.setButtonEnabled(true);
					if (marginRight.isLengthButton()) {
						marginRight.setFieldEnabled(true);
					}
				}
			}
		});
		marginBottomBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				if (ItemEvent.SELECTED != e.getStateChange()) {
					marginBottom.setAllEnabled(false);
				} else {
					marginBottom.setButtonEnabled(true);
					if (marginBottom.isLengthButton()) {
						marginBottom.setFieldEnabled(true);
					}
				}
			}
		});
		marginLeftBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				if (ItemEvent.SELECTED != e.getStateChange()) {
					marginLeft.setAllEnabled(false);
				} else {
					marginLeft.setButtonEnabled(true);
					if (marginLeft.isLengthButton()) {
						marginLeft.setFieldEnabled(true);
					}
				}
			}
		});

		return pane;
	}


	public String getString() {
		StringBuffer buff = new StringBuffer();

		if (setFlag) {
			for (int i = 0; i < JHime.CSS_TAB_COUNT; i++) {
				buff.append("\t");
			}
			buff.append("margin:");
		}
		if (marginTopBtn.isSelected()) {
			if (!setFlag) {
				for (int i = 0; i < JHime.CSS_TAB_COUNT; i++) {
					buff.append("\t");
				}
				buff.append("margin-top:");
			}
			if (marginTop.isLengthButton()) {
				buff.append(" " + marginTop.getLengthField());
				buff.append(marginTop.getLengthBox());
			} else if (marginTop.isAutoButton()) {
				buff.append(" auto");
			} else {
				buff.append(" inherit");
			}
			if (!setFlag) {
				buff.append(";\n");
			}
		}
		if (marginRightBtn.isSelected()) {
			if (!setFlag) {
				for (int i = 0; i < JHime.CSS_TAB_COUNT; i++) {
					buff.append("\t");
				}
				buff.append("margin-right:");
			}
			if (marginRight.isLengthButton()) {
				buff.append(" " + marginRight.getLengthField());
				buff.append(marginRight.getLengthBox());
			} else if (marginRight.isAutoButton()) {
				buff.append(" auto");
			} else {
				buff.append(" inherit");
			}
			if (!setFlag) {
				buff.append(";\n");
			}
		}
		if (marginBottomBtn.isSelected()) {
			if (!setFlag) {
				for (int i = 0; i < JHime.CSS_TAB_COUNT; i++) {
					buff.append("\t");
				}
				buff.append("margin-bottom:");
			}
			if (marginBottom.isLengthButton()) {
				buff.append(" " + marginBottom.getLengthField());
				buff.append(marginBottom.getLengthBox());
			} else if (marginBottom.isAutoButton()) {
				buff.append(" auto");
			} else {
				buff.append(" inherit");
			}
			if (!setFlag) {
				buff.append(";\n");
			}
		}
		if (marginLeftBtn.isSelected()) {
			if (!setFlag) {
				for (int i = 0; i < JHime.CSS_TAB_COUNT; i++) {
					buff.append("\t");
				}
				buff.append("margin-left:");
			}
			if (marginLeft.isLengthButton()) {
				buff.append(" " + marginLeft.getLengthField());
				buff.append(marginLeft.getLengthBox());
			} else if (marginLeft.isAutoButton()) {
				buff.append(" auto");
			} else {
				buff.append(" inherit");
			}
			if (!setFlag) {
				buff.append(";\n");
			}
		}
		if (setFlag) {
			buff.append(";\n");
		}

		return buff.toString();
	}
}