//
//  CSSTableLayoutDialog.java
//  JHime
//
//  Created by 山下 弘隆 on 08/04/27.
//  Copyright 2008 __MyCompanyName__. All rights reserved.
//

import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.event.ItemListener;
import java.awt.event.ItemEvent;

import javax.swing.ButtonGroup;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

import javax.swing.border.LineBorder;

public class CSSTableDialog extends HTMLDialog {
	private JCheckBox layoutBtn   = new JCheckBox("table-layout");
	private JCheckBox collapseBtn = new JCheckBox("border-collapse");
	private JCheckBox spacingBtn  = new JCheckBox("border-spacing");

	private String[] layout_str = {
		"auto", "fixed", "inherit"
	};
	private JComboBox layoutBox = new JComboBox(layout_str);
	private String[] collapse_str = {
		"separate", "collapse", "inherit"
	};
	private JComboBox collapseBox = new JComboBox(collapse_str);
	private JRadioButton spacingLengthBtn  = new JRadioButton("長さ", true);
	private JRadioButton spacingInheritBtn = new JRadioButton("inherit");

	private JLabel spacingLengthLabel1 = new JLabel("(左右)間隔", JLabel.RIGHT);
	private JTextField spacingLengthField1  = new JTextField(10);
	private String[] spacingLength_str = {
		"em", "ex", "px", "in", "cm", "mm", "pt", "pc"
	};
	private JComboBox spacingLengthBox1		= new JComboBox(spacingLength_str);
	private JCheckBox spacingLengthBtn2		= new JCheckBox("上下間隔");
	private JTextField spacingLengthField2  = new JTextField(10);
	private JComboBox spacingLengthBox2		= new JComboBox(spacingLength_str);


	public CSSTableDialog (TextView view) {
		super(view);
		setDialog(view, "テーブル設定", 100, 100);
	}

	protected JPanel createHTMLDocumentPanel() {
		ButtonGroup btnGroup = new ButtonGroup();
		btnGroup.add(spacingLengthBtn);
		btnGroup.add(spacingInheritBtn);

		GridBagLayout layout = new GridBagLayout();
		GridBagConstraints gc = new GridBagConstraints();
		JPanel pane = new JPanel(layout);

		gc.fill = GridBagConstraints.HORIZONTAL;
		gc.insets = new Insets(5,5,5,5);
		gc.gridwidth = 1;
		gc.gridheight = 1;

		gridLayoutComponent(pane, layout, gc, layoutBtn,			0, 0, true);
		gc.gridwidth = 2;
		gridLayoutComponent(pane, layout, gc, layoutBox,			1, 0, false);
		gc.gridwidth = 1;
		gridLayoutComponent(pane, layout, gc, collapseBtn,			0, 1, true);
		gc.gridwidth = 2;
		gridLayoutComponent(pane, layout, gc, collapseBox,			1, 1, false);
		gc.gridwidth = 1;
		gridLayoutComponent(pane, layout, gc, spacingBtn,			0, 2, true);
		gridLayoutComponent(pane, layout, gc, spacingLengthBtn,		1, 2, false);
		gridLayoutComponent(pane, layout, gc, spacingLengthLabel1,	2, 2, false);
		gridLayoutComponent(pane, layout, gc, spacingLengthField1,	3, 2, false);
		gridLayoutComponent(pane, layout, gc, spacingLengthBox1,	4, 2, false);
		gridLayoutComponent(pane, layout, gc, spacingLengthBtn2,	2, 3, false);
		gridLayoutComponent(pane, layout, gc, spacingLengthField2,	3, 3, false);
		gridLayoutComponent(pane, layout, gc, spacingLengthBox2,	4, 3, false);
		gridLayoutComponent(pane, layout, gc, spacingInheritBtn,	1, 4, false);

		layoutBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, layoutBox);
			}
		});
		collapseBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, collapseBox);
			}
		});
		spacingBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, spacingInheritBtn);
				enabledSetting(e, spacingLengthBtn);
				if (ItemEvent.SELECTED != e.getStateChange()) {
					spacingLengthLabel1.setEnabled(false);
					spacingLengthField1.setEnabled(false);
					spacingLengthBox1.setEnabled(false);
					spacingLengthBtn2.setEnabled(false);
					spacingLengthField2.setEnabled(false);
					spacingLengthBox2.setEnabled(false);
				} else if (spacingLengthBtn.isSelected()) {
					spacingLengthLabel1.setEnabled(true);
					spacingLengthField1.setEnabled(true);
					spacingLengthBox1.setEnabled(true);
					spacingLengthBtn2.setEnabled(true);
					if (spacingLengthBtn2.isSelected()) {
						spacingLengthBox2.setEnabled(true);
						spacingLengthField2.setEnabled(true);
					}
				}
			}
		});
		spacingLengthBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, spacingLengthBtn2);
				enabledSetting(e, spacingLengthBox1);
				enabledSetting(e, spacingLengthLabel1);
				enabledSetting(e, spacingLengthField1);
				if (ItemEvent.SELECTED != e.getStateChange()) {
					spacingLengthBox2.setEnabled(false);
					spacingLengthField2.setEnabled(false);
				} else if (spacingLengthBtn2.isSelected()) {
					spacingLengthBox2.setEnabled(true);
					spacingLengthField2.setEnabled(true);
				}
			}
		});
		spacingLengthBtn2.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, spacingLengthBox2);
				enabledSetting(e, spacingLengthField2);
			}
		});

		return pane;
	}


	public String getString() {
		StringBuffer buff = new StringBuffer();

		if (layoutBtn.isSelected()) {
			for (int i = 0; i < JHime.CSS_TAB_COUNT; i++) {
				buff.append("\t");
			}
			buff.append("table-layout: ");
			buff.append(layoutBox.getSelectedItem());
			buff.append(";\n");
		}
		if (collapseBtn.isSelected()) {
			for (int i = 0; i < JHime.CSS_TAB_COUNT; i++) {
				buff.append("\t");
			}
			buff.append("border-collapse: ");
			buff.append(collapseBox.getSelectedItem());
			buff.append(";\n");
		}
		if (spacingBtn.isSelected()) {
			for (int i = 0; i < JHime.CSS_TAB_COUNT; i++) {
				buff.append("\t");
			}
			buff.append("border-spacing: ");
			if (spacingLengthBtn.isSelected()) {
				buff.append(spacingLengthField1.getText());
				buff.append(spacingLengthBox1.getSelectedItem());
				if (spacingLengthBtn2.isSelected()) {
					buff.append(" " + spacingLengthField2.getText());
					buff.append(spacingLengthBox2.getSelectedItem());
				}
			} else {
				buff.append("inherit");
			}
			buff.append(";\n");
		}

		return buff.toString();
	}
}