//
//  CSSWidthDialog.java
//  JHime
//
//  Created by 山下 弘隆 on 08/04/26.
//  Copyright 2008 __MyCompanyName__. All rights reserved.
//

import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.event.ItemListener;
import java.awt.event.ItemEvent;

import javax.swing.ButtonGroup;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

import javax.swing.border.LineBorder;

public class CSSWidthDialog extends HTMLDialog {
	private JRadioButton lengthBtn	= new JRadioButton("長さ・%値", true);
	private JRadioButton autoBtn	= new JRadioButton("auto");
	private JRadioButton inheritBtn	= new JRadioButton("inherit");

	private JTextField lengthField	= new JTextField(10);
	private String[] length_str = {
		"%", "em", "ex", "px", "in", "cm", "mm", "pt", "pc"
	};
	private JComboBox lengthBox		= new JComboBox(length_str);

	private boolean widthFlag;

	public CSSWidthDialog (TextView view, boolean flag) {
		super(view);
		widthFlag = flag;
		String title;
		if (widthFlag) {
			title = "widthプロパティ";
		} else {
			title = "heightプロパティ";
		}
		setDialog(view, title, 100, 100);
	}

	protected JPanel createHTMLDocumentPanel() {
		ButtonGroup btnGroup = new ButtonGroup();
		btnGroup.add(lengthBtn);
		btnGroup.add(autoBtn);
		btnGroup.add(inheritBtn);

		GridBagLayout layout = new GridBagLayout();
		GridBagConstraints gc = new GridBagConstraints();
		JPanel pane = new JPanel(layout);

		gc.fill = GridBagConstraints.HORIZONTAL;
		gc.insets = new Insets(5,5,5,5);
		gc.gridwidth = 1;
		gc.gridheight = 1;

		gridLayoutComponent(pane, layout, gc, lengthBtn,	0, 0, true);
		gridLayoutComponent(pane, layout, gc, lengthField,	1, 0, true);
		gridLayoutComponent(pane, layout, gc, lengthBox,	2, 0, true);
		gridLayoutComponent(pane, layout, gc, autoBtn,		0, 1, true);
		gridLayoutComponent(pane, layout, gc, inheritBtn,	0, 2, true);

		lengthBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, lengthBox);
				enabledSetting(e, lengthField);
			}
		});

		return pane;
	}


	public String getString() {
		StringBuffer buff = new StringBuffer();

		for (int i = 0; i < JHime.CSS_TAB_COUNT; i++) {
			buff.append("\t");
		}
		if (widthFlag) {
			buff.append("width: ");
		} else {
			buff.append("height: ");
		}
		if (lengthBtn.isSelected()) {
			buff.append(lengthField.getText());
			buff.append(lengthBox.getSelectedItem());
		} else if (autoBtn.isSelected()) {
			buff.append("auto");
		} else {
			buff.append("inherit");
		}
		buff.append(";\n");

		return buff.toString();
	}
}