//
//  HTMLAttributeDialog.java
//  JHime
//
//  Created by 山下 弘隆 on 08/04/14.
//  Copyright 2008 __MyCompanyName__. All rights reserved.
//

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Point;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.event.ItemListener;
import java.awt.event.ItemEvent;
import java.awt.event.WindowListener;
import java.awt.event.WindowEvent;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class HTMLAttributeDialog extends JDialog implements WindowListener {
	private JCheckBox idBtn		= new JCheckBox("id属性");
	private JCheckBox classBtn	= new JCheckBox("class属性");
	private JCheckBox styleBtn	= new JCheckBox("style属性");
	private JCheckBox titleBtn	= new JCheckBox("title属性");
	private JTextField idField		= new JTextField(30);
	private JTextField classField	= new JTextField(30);
	private JTextField styleField	= new JTextField(30);
	private JTextField titleField	= new JTextField(30);

	private String[] dir_str = {"ltr", "rtl"};
	private JCheckBox langBtn		= new JCheckBox("lang属性");
	private JCheckBox xmlLangBtn	= new JCheckBox("xml:lang属性");
	private JCheckBox dirBtn		= new JCheckBox("dir属性");
	private JTextField langField	= new JTextField("ja", 10);
	private JTextField xmlLangField = new JTextField("ja", 10);
	private JComboBox dirBox		= new JComboBox(dir_str);

	private JCheckBox clickBtn		= new JCheckBox("onclick属性");
	private JCheckBox dbClickBtn	= new JCheckBox("ondbclick属性");
	private JCheckBox mouseDownBtn	= new JCheckBox("onmousedown属性");
	private JCheckBox mouseUpBtn	= new JCheckBox("onmouseup属性");
	private JCheckBox mouseMoveBtn	= new JCheckBox("onmousemove属性");
	private JCheckBox mouseOutBtn	= new JCheckBox("onmouseout属性");
	private JCheckBox keyPressBtn	= new JCheckBox("onkeypress属性");
	private JCheckBox keyDownBtn	= new JCheckBox("onkeydown属性");
	private JCheckBox keyUpBtn		= new JCheckBox("onkeyup属性");
	private JTextField clickField		= new JTextField(25);
	private JTextField dbClickField		= new JTextField(25);
	private JTextField mouseDownField	= new JTextField(25);
	private JTextField mouseUpField		= new JTextField(25);
	private JTextField mouseMoveField	= new JTextField(25);
	private JTextField mouseOutField	= new JTextField(25);
	private JTextField keyPressField	= new JTextField(25);
	private JTextField keyDownField		= new JTextField(25);
	private JTextField keyUpField		= new JTextField(25);

	private JCheckBox accessKeyBtn	= new JCheckBox("accesskey属性");
	private JCheckBox tabIndexBtn	= new JCheckBox("tabindex属性");
	private JCheckBox onFocusBtn	= new JCheckBox("onfocus属性");
	private JCheckBox onBlurBtn		= new JCheckBox("onblur属性");
	private JTextField accessKeyField	= new JTextField(10);
	private JTextField tabIndexField	= new JTextField(10);
	private JTextField onFocusField		= new JTextField(25);
	private JTextField onBlurField		= new JTextField(25);

	private JCheckBox onLoadBtn		= new JCheckBox("onload属性");
	private JCheckBox onUnLoadBtn	= new JCheckBox("onunload属性");
	private JCheckBox onSubmitBtn	= new JCheckBox("onsubmit属性");
	private JCheckBox onResetBtn	= new JCheckBox("onreset属性");
	private JCheckBox onSelectBtn	= new JCheckBox("onselect属性");
	private JCheckBox onChangeBtn	= new JCheckBox("onchange属性");
	private JTextField onLoadField		= new JTextField(25);
	private JTextField onUnLoadField	= new JTextField(25);
	private JTextField onSubmitField	= new JTextField(25);
	private JTextField onResetField		= new JTextField(25);
	private JTextField onSelectField	= new JTextField(25);
	private JTextField onChangeField	= new JTextField(25);

	private String tagString;
	private boolean resultFlag;

	public HTMLAttributeDialog (TextView view) {
		super(view, "汎用属性", true);

		JTabbedPane tabPane = new JTabbedPane();
		tabPane.add("コア属性", this.createCoreAttributePanel());
		tabPane.add("国際化属性", this.createI18NAttributePanel());
		tabPane.add("イベント属性", this.createEventAttributePanel());
		tabPane.add("フォーカス属性", this.createFocusAttributePanel());
		tabPane.add("その他イベント属性", this.createOtherEventAttributePanel());
		getContentPane().add(tabPane, BorderLayout.CENTER);

		JButton btn1 = new JButton("設定");
		JButton btn2 = new JButton("キャンセル");

		btn1.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				dispose();
				resultFlag = true;
			}
		});
		btn2.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				dispose();
			}
		});

		JPanel pane = new JPanel();
		pane.add(btn1);
		pane.add(btn2);
		getContentPane().add(pane, BorderLayout.SOUTH);

		this.setDefaultCloseOperation(DISPOSE_ON_CLOSE);


		int width  = this.getPreferredSize().width + 50;
		int height = this.getPreferredSize().height + 50;
		
		Point viewPoint = view.getLocationOnScreen();
		Dimension dim = view.getSize();
		int x, y = viewPoint.y;
		x = viewPoint.x + dim.width / 2 - (width / 2);
		if (x < 0) {
			x = viewPoint.x;
		}
		
		this.setBounds(x, y, width, height); //420);
		this.setResizable(false);
		this.setVisible(true);
	}

	private void gridLayoutComponent(JPanel pane,
									 GridBagLayout layout,
									 GridBagConstraints gc,
									 Component comp, int x, int y, boolean enabled) {
		gc.gridx = x;
		gc.gridy = y;
		layout.setConstraints(comp, gc);
		pane.add(comp);
		comp.setEnabled(enabled);
	}

	private void enabledSetting(ItemEvent e, Component comp) {
		if (ItemEvent.SELECTED == e.getStateChange()) {
			comp.setEnabled(true);
			comp.requestFocusInWindow();
		} else {
			comp.setEnabled(false);
		}
	}
	
	private JPanel createCoreAttributePanel() {
		GridBagLayout layout = new GridBagLayout();
		GridBagConstraints gc = new GridBagConstraints();
		JPanel pane = new JPanel(layout);

		gc.fill = GridBagConstraints.HORIZONTAL;
		gc.insets = new Insets(20,5,20,5);
		gc.gridwidth = 1;
		gc.gridheight = 1;

		gridLayoutComponent(pane, layout, gc, idBtn,	  0, 0, true);
		gridLayoutComponent(pane, layout, gc, idField,	  1, 0, false);
		gridLayoutComponent(pane, layout, gc, classBtn,   0, 1, true);
		gridLayoutComponent(pane, layout, gc, classField, 1, 1, false);
		gridLayoutComponent(pane, layout, gc, styleBtn,   0, 2, true);
		gridLayoutComponent(pane, layout, gc, styleField, 1, 2, false);
		gridLayoutComponent(pane, layout, gc, titleBtn,   0, 3, true);
		gridLayoutComponent(pane, layout, gc, titleField, 1, 3, false);

		idBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, idField);
			}
		});
		classBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, classField);
			}
		});
		styleBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, styleField);
			}
		});
		titleBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, titleField);
			}
		});

		return pane;
	}

	private JPanel createI18NAttributePanel() {
		GridBagLayout layout = new GridBagLayout();
		GridBagConstraints gc = new GridBagConstraints();
		JPanel pane = new JPanel(layout);

		gc.fill = GridBagConstraints.HORIZONTAL;
		gc.insets = new Insets(20,5,20,5);
		gc.gridwidth = 1;
		gc.gridheight = 1;

		gridLayoutComponent(pane, layout, gc, langBtn,	    0, 0, true);
		gridLayoutComponent(pane, layout, gc, langField,    1, 0, false);
		gridLayoutComponent(pane, layout, gc, xmlLangBtn,   0, 1, true);
		gridLayoutComponent(pane, layout, gc, xmlLangField,	1, 1, false);
		gridLayoutComponent(pane, layout, gc, dirBtn,		0, 2, true);
		gridLayoutComponent(pane, layout, gc, dirBox,		1, 2, false);

		langBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, langField);
			}
		});
		xmlLangBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, xmlLangField);
			}
		});
		dirBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, dirBox);
			}
		});

		return pane;
	}

	private JPanel createEventAttributePanel() {
		GridBagLayout layout = new GridBagLayout();
		GridBagConstraints gc = new GridBagConstraints();
		JPanel pane = new JPanel(layout);

		gc.fill = GridBagConstraints.HORIZONTAL;
		gc.insets = new Insets(5,5,5,5);
		gc.gridwidth = 1;
		gc.gridheight = 1;

		gridLayoutComponent(pane, layout, gc, clickBtn,			0, 0, true);
		gridLayoutComponent(pane, layout, gc, clickField,		1, 0, false);
		gridLayoutComponent(pane, layout, gc, dbClickBtn,		0, 1, true);
		gridLayoutComponent(pane, layout, gc, dbClickField,		1, 1, false);
		gridLayoutComponent(pane, layout, gc, mouseDownBtn,		0, 2, true);
		gridLayoutComponent(pane, layout, gc, mouseDownField,	1, 2, false);
		gridLayoutComponent(pane, layout, gc, mouseUpBtn,		0, 3, true);
		gridLayoutComponent(pane, layout, gc, mouseUpField,		1, 3, false);
		gridLayoutComponent(pane, layout, gc, mouseMoveBtn,		0, 4, true);
		gridLayoutComponent(pane, layout, gc, mouseMoveField,	1, 4, false);
		gridLayoutComponent(pane, layout, gc, mouseOutBtn,		0, 5, true);
		gridLayoutComponent(pane, layout, gc, mouseOutField,	1, 5, false);
		gridLayoutComponent(pane, layout, gc, keyPressBtn,		0, 6, true);
		gridLayoutComponent(pane, layout, gc, keyPressField,	1, 6, false);
		gridLayoutComponent(pane, layout, gc, keyDownBtn,		0, 7, true);
		gridLayoutComponent(pane, layout, gc, keyDownField,		1, 7, false);
		gridLayoutComponent(pane, layout, gc, keyUpBtn,			0, 8, true);
		gridLayoutComponent(pane, layout, gc, keyUpField,		1, 8, false);

		clickBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, clickField);
			}
		});
		dbClickBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, dbClickField);
			}
		});
		mouseDownBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, mouseDownField);
			}
		});
		mouseUpBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, mouseUpField);
			}
		});
		mouseMoveBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, mouseMoveField);
			}
		});
		mouseOutBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, mouseOutField);
			}
		});
		keyPressBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, keyPressField);
			}
		});
		keyDownBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, keyDownField);
			}
		});
		keyUpBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, keyUpField);
			}
		});

		return pane;
	}

	private JPanel createFocusAttributePanel() {
		GridBagLayout layout = new GridBagLayout();
		GridBagConstraints gc = new GridBagConstraints();
		JPanel pane = new JPanel(layout);

		gc.fill = GridBagConstraints.HORIZONTAL;
		gc.insets = new Insets(20,5,20,5);
		gc.gridwidth = 1;
		gc.gridheight = 1;

		gridLayoutComponent(pane, layout, gc, accessKeyBtn,		0, 0, true);
		gridLayoutComponent(pane, layout, gc, accessKeyField,   1, 0, false);
		gridLayoutComponent(pane, layout, gc, tabIndexBtn,		0, 1, true);
		gridLayoutComponent(pane, layout, gc, tabIndexField,	1, 1, false);
		gridLayoutComponent(pane, layout, gc, onFocusBtn,		0, 2, true);
		gc.gridwidth = 2;
		gridLayoutComponent(pane, layout, gc, onFocusField,		1, 2, false);
		gc.gridwidth = 1;
		gridLayoutComponent(pane, layout, gc, onBlurBtn,		0, 3, true);
		gc.gridwidth = 2;
		gridLayoutComponent(pane, layout, gc, onBlurField,		1, 3, false);

		accessKeyBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, accessKeyField);
			}
		});
		tabIndexBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, tabIndexField);
			}
		});
		onFocusBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, onFocusField);
			}
		});
		onBlurBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, onBlurField);
			}
		});

		return pane;
	}

	private JPanel createOtherEventAttributePanel() {
		GridBagLayout layout = new GridBagLayout();
		GridBagConstraints gc = new GridBagConstraints();
		JPanel pane = new JPanel(layout);

		gc.fill = GridBagConstraints.HORIZONTAL;
		gc.insets = new Insets(10,5,10,5);
		gc.gridwidth = 1;
		gc.gridheight = 1;

		gridLayoutComponent(pane, layout, gc, onLoadBtn,		0, 0, true);
		gridLayoutComponent(pane, layout, gc, onLoadField,		1, 0, false);
		gridLayoutComponent(pane, layout, gc, onUnLoadBtn,		0, 1, true);
		gridLayoutComponent(pane, layout, gc, onUnLoadField,	1, 1, false);
		gridLayoutComponent(pane, layout, gc, onSubmitBtn,		0, 2, true);
		gridLayoutComponent(pane, layout, gc, onSubmitField,	1, 2, false);
		gridLayoutComponent(pane, layout, gc, onResetBtn,		0, 3, true);
		gridLayoutComponent(pane, layout, gc, onResetField,		1, 3, false);
		gridLayoutComponent(pane, layout, gc, onSelectBtn,		0, 4, true);
		gridLayoutComponent(pane, layout, gc, onSelectField,	1, 4, false);
		gridLayoutComponent(pane, layout, gc, onChangeBtn,		0, 5, true);
		gridLayoutComponent(pane, layout, gc, onChangeField,	1, 5, false);

		onLoadBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, onLoadField);
			}
		});
		onUnLoadBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, onUnLoadField);
			}
		});
		onSubmitBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, onSubmitField);
			}
		});
		onResetBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, onResetField);
			}
		});
		onSelectBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, onSelectField);
			}
		});
		onChangeBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, onChangeField);
			}
		});

		return pane;
	}

	public void windowActivated(WindowEvent e) { }
	public void	windowClosed(WindowEvent e) {
		resultFlag = false;
	}
	public void	windowClosing(WindowEvent e) { }
	public void	windowDeactivated(WindowEvent e) { }
	public void	windowDeiconified(WindowEvent e) { }
	public void	windowIconified(WindowEvent e) { }
	public void	windowOpened(WindowEvent e)  { }

	public boolean getResult() {
		return resultFlag;
	}

	public String getString() {
		StringBuffer buff = new StringBuffer();

		if (idBtn.isSelected()) {
			buff.append(" id=\"" + idField.getText() + "\"");
		}
		if (classBtn.isSelected()) {
			buff.append(" class=\"" + classField.getText() + "\"");
		}
		if (styleBtn.isSelected()) {
			buff.append(" style=\"" + styleField.getText() + "\"");
		}
		if (titleBtn.isSelected()) {
			buff.append(" title=\"" + titleField.getText() + "\"");
		}

		if (langBtn.isSelected()) {
			buff.append(" lang=\"" + langField.getText() + "\"");
		}
		if (xmlLangBtn.isSelected()) {
			buff.append(" xml:lang=\"" + xmlLangField.getText() + "\"");
		}
		if (dirBtn.isSelected()) {
			buff.append(" dir=\"" + (String)dirBox.getSelectedItem() + "\"");
		}

		if (clickBtn.isSelected()) {
			buff.append(" onclick=\"" + clickField.getText() + "\"");
		}
		if (dbClickBtn.isSelected()) {
			buff.append(" ondbclick=\"" + dbClickField.getText() + "\"");
		}
		if (mouseDownBtn.isSelected()) {
			buff.append(" onmousedown=\"" + mouseDownField.getText() + "\"");
		}
		if (mouseUpBtn.isSelected()) {
			buff.append(" onmouseup=\"" + mouseUpField.getText() + "\"");
		}
		if (mouseMoveBtn.isSelected()) {
			buff.append(" onmousemove=\"" + mouseMoveField.getText() + "\"");
		}
		if (mouseOutBtn.isSelected()) {
			buff.append(" onmouseout=\"" + mouseOutField.getText() + "\"");
		}
		if (keyPressBtn.isSelected()) {
			buff.append(" onkeypress=\"" + keyPressField.getText() + "\"");
		}
		if (keyDownBtn.isSelected()) {
			buff.append(" onkeydown=\"" + keyDownField.getText() + "\"");
		}
		if (keyUpBtn.isSelected()) {
			buff.append(" onkeyup=\"" + keyUpField.getText() + "\"");
		}

		if (accessKeyBtn.isSelected()) {
			buff.append(" accesskey=\"" + accessKeyField.getText() + "\"");
		}
		if (tabIndexBtn.isSelected()) {
			buff.append(" tabindex=\"" + tabIndexField.getText() + "\"");
		}
		if (onFocusBtn.isSelected()) {
			buff.append(" onfoucs=\"" + onFocusField.getText() + "\"");
		}
		if (onBlurBtn.isSelected()) {
			buff.append(" onblur=\"" + onBlurField.getText() + "\"");
		}

		if (onLoadBtn.isSelected()) {
			buff.append(" onload=\"" + onLoadField.getText() + "\"");
		}
		if (onUnLoadBtn.isSelected()) {
			buff.append(" onunload=\"" + onUnLoadField.getText() + "\"");
		}
		if (onSubmitBtn.isSelected()) {
			buff.append(" onsubmit=\"" + onSubmitField.getText() + "\"");
		}
		if (onResetBtn.isSelected()) {
			buff.append(" onreset=\"" + onResetField.getText() + "\"");
		}
		if (onSelectBtn.isSelected()) {
			buff.append(" onselect=\"" + onSelectField.getText() + "\"");
		}
		if (onChangeBtn.isSelected()) {
			buff.append(" onchange=\"" + onChangeField.getText() + "\"");
		}

		return buff.toString();
	}
}