//
//  HTMLBasicDialog.java
//  JHime
//
//  Created by 山下 弘隆 on 08/04/09.
//  Copyright 2008 __MyCompanyName__. All rights reserved.
//

import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;

import java.awt.event.ItemListener;
import java.awt.event.ItemEvent;

import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class HTMLBasicDialog extends HTMLDialog {
	private JCheckBox xmlBtn		= new JCheckBox("XML宣言", true);
	private JCheckBox dtdBtn		= new JCheckBox("DTD宣言", true);
	private JCheckBox xmlnsBtn		= new JCheckBox("xmlns属性", true);
	private JCheckBox xmlLangBtn	= new JCheckBox("xml:lang属性", true);
	private JCheckBox langBtn		= new JCheckBox("lang属性", true);

	private JLabel versionLabel		= new JLabel("version", JLabel.RIGHT);
	private JTextField xmlVersionField	= new JTextField("1.0", 5);
	private JLabel encodingLabel		= new JLabel("encoding", JLabel.RIGHT);
	private String[] xmlEncoding_str	= {"UTF-8", "UTF-16", "Shift_JIS", "EUC-JP", "ISO-2022-JP"};
	private JComboBox xmlEncodingBox	= new JComboBox(xmlEncoding_str);
	private String[] dtd_str	= {"XHTML 1.0 Strict", "XHTML 1.0 Transitional", "XHTML 1.0 Frameset",
								   "XHTML 1.1",
								   "HTML 4.01 Strict", "HTML 4.01 Transitional", "HTML 4.01 Frameset"};
	private JComboBox dtdBox	= new JComboBox(dtd_str);
	private JTextField xmlnsField	= new JTextField("http://www.w3.org/1999/xhtml", 25);
	private JTextField xmlLangField	= new JTextField("ja", 5);
	private JTextField langField	= new JTextField("ja", 5);

	public HTMLBasicDialog (TextView view) {
		super(view);
		setDialog(view, "HTML文書定義", 500, 300);
	}
	
	protected JPanel createHTMLDocumentPanel() {
		GridBagLayout layout = new GridBagLayout();
		GridBagConstraints gc = new GridBagConstraints();
		JPanel pane = new JPanel(layout);

		gc.fill = GridBagConstraints.HORIZONTAL;
		gc.insets = new Insets(10,5,10,5);
		gc.gridwidth = 1;
		gc.gridheight = 1;

		gridLayoutComponent(pane, layout, gc, xmlBtn,		   0, 0, true);
		gridLayoutComponent(pane, layout, gc, versionLabel,    1, 0, true);
		gridLayoutComponent(pane, layout, gc, xmlVersionField, 2, 0, true);
		gridLayoutComponent(pane, layout, gc, encodingLabel,   3, 0, true);
		gridLayoutComponent(pane, layout, gc, xmlEncodingBox,  4, 0, true);
		gridLayoutComponent(pane, layout, gc, dtdBtn,		   0, 1, true);
		gc.gridwidth = 3;
		gridLayoutComponent(pane, layout, gc, dtdBox,		   1, 1, true);
		gc.gridwidth = 1;
		gridLayoutComponent(pane, layout, gc, xmlnsBtn,		   0, 2, true);
		gc.gridwidth = 4;
		gridLayoutComponent(pane, layout, gc, xmlnsField,	   1, 2, false);
		gc.gridwidth = 1;
		gridLayoutComponent(pane, layout, gc, xmlLangBtn,	   0, 3, true);
		gridLayoutComponent(pane, layout, gc, xmlLangField,	   1, 3, true);
		gridLayoutComponent(pane, layout, gc, langBtn,	       0, 4, true);
		gridLayoutComponent(pane, layout, gc, langField,	   1, 4, true);

		xmlBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, encodingLabel);
				enabledSetting(e, xmlEncodingBox);
				enabledSetting(e, versionLabel);
				enabledSetting(e, xmlVersionField);
			}
		});
		dtdBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, dtdBox);
			}
		});
		xmlLangBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, xmlLangField);
			}
		});
		langBtn.addItemListener(new ItemListener(){
			public void itemStateChanged(ItemEvent e) {
				enabledSetting(e, langField);
			}
		});

		return pane;
	}

	public String getStringStart() {
		StringBuffer buff = new StringBuffer();

		if (xmlBtn.isSelected()) {
			buff.append("<?xml version=\"" + xmlVersionField.getText() +
						"\" encoding=\"" + (String)xmlEncodingBox.getSelectedItem() + "\"?>\n");
		}
		if (dtdBtn.isSelected()) {
			switch(dtdBox.getSelectedIndex()) {
				case 0:
					buff.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"\n");
					buff.append("                      \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n");
					break;
				case 1:
					buff.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitionl//EN\"\n");
					buff.append("                      \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n");
					break;
				case 2:
					buff.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Frameset//EN\"\n");
					buff.append("                      \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd\">\n");
					break;
				case 3:
					buff.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.1//EN\"\n");
					buff.append("                      \"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\">\n");
					break;
				case 4:
					buff.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\"\n");
					buff.append("                      \"http://www.w3.org/TR/html4/strict.dtd\">\n");
					break;
				case 5:
					buff.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"\n");
					buff.append("                      \"http://www.w3.org/TR/html4/loose.dtd\">\n");
					break;
				case 6:
					buff.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Frameset//EN\"\n");
					buff.append("                      \"http://www.w3.org/TR/html4/frameset.dtd\">\n");
					break;
			}
		}
		buff.append("<html");
		if (xmlnsBtn.isSelected()) {
			buff.append(" xmlns=\"" + xmlnsField.getText() + "\"");
		}
		if (xmlLangBtn.isSelected()) {
			buff.append(" xml:lang=\"" + xmlLangField.getText() + "\"");
		}
		if (langBtn.isSelected()) {
			buff.append(" lang=\"" + langField.getText() + "\"");
		}
		buff.append(">\n");

		return buff.toString();
	}

	public String getStringEnd() {
		return "</html>";
	}
}