//
//  HTMLDialog.java
//  JHime
//
//  Created by 山下 弘隆 on 08/04/08.
//  Copyright 2008 __MyCompanyName__. All rights reserved.
//

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.event.ItemListener;
import java.awt.event.ItemEvent;
import java.awt.event.WindowListener;
import java.awt.event.WindowEvent;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;

import javax.swing.filechooser.FileFilter;

public abstract class HTMLDialog extends JDialog implements WindowListener {
	private TextView view;

	protected String tagString;
	protected boolean resultFlag;

	public HTMLDialog (TextView view) {
		super(view, null, true);
		this.view = view;
	}

	protected void setDialog(TextView view, String title, int width, int height) {
		setTitle(title);

		JPanel pane = this.createHTMLDocumentPanel();
		getContentPane().add(pane, BorderLayout.CENTER);

		JButton btn1 = new JButton("設定");
		JButton btn2 = new JButton("キャンセル");

		btn1.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				dispose();
				resultFlag = true;
			}
		});
		btn2.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
				dispose();
			}
		});

		pane = new JPanel();
		pane.add(btn1);
		pane.add(btn2);
		getContentPane().add(pane, BorderLayout.SOUTH);

		this.setDefaultCloseOperation(DISPOSE_ON_CLOSE);

		Dimension dim = this.getPreferredSize();
		width = dim.width + 50;
		height = dim.height + 50;

		int x = view.getLocationOnScreen().x;
		int y = view.getLocationOnScreen().y;
		x = x + view.getSize().width / 2 - (width / 2);
		if (x < 0) {
			x = view.getLocationOnScreen().x;
		}

//		System.out.println("w=" + dim.width + " ww=" + width);
//		System.out.println("h=" + dim.height + " hh=" + height);

		this.setBounds(x, y, width, height);
		this.setResizable(false);
		this.setVisible(true);
	}

	protected void gridLayoutComponent(JPanel pane,
									 GridBagLayout layout,
									 GridBagConstraints gc,
									 Component comp, int x, int y, boolean enabled) {
		gc.gridx = x;
		gc.gridy = y;
		layout.setConstraints(comp, gc);
		pane.add(comp);
		comp.setEnabled(enabled);
	}

	protected void enabledSetting(ItemEvent e, Component comp) {
		if (ItemEvent.SELECTED == e.getStateChange()) {
			comp.setEnabled(true);
			comp.requestFocusInWindow();
		} else {
			comp.setEnabled(false);
		}
	}

	protected void fileSelect(JTextField comp, String[] filter) {
		JFileChooser fc = new JFileChooser(this.view.getUserDir());
		FileFilter fl = new FileIOFilter(filter[0]);
		fc.addChoosableFileFilter(fl);
		for (int i = 1; i < filter.length; i++) {
			fc.addChoosableFileFilter(new FileIOFilter(filter[i]));
		}
		fc.setFileFilter(fl);

		int ret = fc.showOpenDialog(this);
		if (ret == JFileChooser.APPROVE_OPTION) {
			this.view.setUserDir(fc.getSelectedFile().getParent());
			if (JHime.LINK_FILE) {
				comp.setText(fc.getSelectedFile().getName());
			} else if (JHime.LINK_PATH) {
				comp.setText(fc.getSelectedFile().getPath());
			} else {
				comp.setText(JHime.BASEURL + fc.getSelectedFile().getName());
			}
		}
	}

	protected void fileSelect(JTextField comp, JTextField scomp, String[] filter) {
		JFileChooser fc = new JFileChooser(this.view.getUserDir());
		FileFilter fl = new FileIOFilter(filter[0]);
		fc.addChoosableFileFilter(fl);
		for (int i = 1; i < filter.length; i++) {
			fc.addChoosableFileFilter(new FileIOFilter(filter[i]));
		}
		fc.setFileFilter(fl);

		int ret = fc.showOpenDialog(this);
		if (ret == JFileChooser.APPROVE_OPTION) {
			this.view.setUserDir(fc.getSelectedFile().getParent());
			if (JHime.LINK_FILE) {
				comp.setText(fc.getSelectedFile().getName());
			} else if (JHime.LINK_PATH) {
				comp.setText(fc.getSelectedFile().getPath());
			} else {
				comp.setText(JHime.BASEURL + fc.getSelectedFile().getName());
			}
			scomp.setText(Long.toString(fc.getSelectedFile().length()));
		}
	}
	
	protected abstract JPanel createHTMLDocumentPanel();

	public void windowActivated(WindowEvent e) { }
	public void	windowClosed(WindowEvent e) {
		resultFlag = false;
	}
	public void	windowClosing(WindowEvent e) { }
	public void	windowDeactivated(WindowEvent e) { }
	public void	windowDeiconified(WindowEvent e) { }
	public void	windowIconified(WindowEvent e) { }
	public void	windowOpened(WindowEvent e)  { }

	public boolean getResult() {
		return resultFlag;
	}

	public String getString() {
		return null;
	}
	
	public String getStringStart() {
		return null;
	}

	public String getStringEnd() {
		return null;
	}
}